/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.util.List;
import org.maachang.util.StringUtil;
import org.maachang.util.net.AbstractNetAdapter;

class NetAdapterByLinux
extends AbstractNetAdapter {
    private static final String IPCONFIG_COMMAND = "ifconfig";
    private static final String ADAPTER_NAME_1 = "link";
    private static final String ADAPTER_NAME_2 = "encap:";
    private static final char DIV_IP_CODE = '.';
    private static final char DIV_MAC_CODE = ':';
    private static final String IP_ADDR = "inet addr:";
    private static final String SUB_NET = "mask";
    private static final String MAC_ADDR = "hwaddr";

    public NetAdapterByLinux() {
        this.init();
    }

    public void load() throws Exception {
        List<String> cmdOut = null;
        String name = null;
        String value = null;
        try {
            try {
                this.clear();
                cmdOut = AbstractNetAdapter.runExec(IPCONFIG_COMMAND);
                int len = cmdOut.size();
                int i = 0;
                int localCheck = 0;
                while (i < len) {
                    char code;
                    int et;
                    int st;
                    int j;
                    int lenJ;
                    int pnt;
                    String bcmd = cmdOut.get(i);
                    String cmd = bcmd.toLowerCase();
                    int off = cmd.indexOf(ADAPTER_NAME_1);
                    if (off != -1 && cmd.indexOf(ADAPTER_NAME_2, off) != -1) {
                        pnt = off;
                        name = StringUtil.trim(bcmd.substring(0, pnt));
                    }
                    if ((pnt = cmd.indexOf(IP_ADDR)) != -1) {
                        lenJ = cmd.length();
                        j = pnt += IP_ADDR.length();
                        st = -1;
                        et = -1;
                        while (j < lenJ) {
                            code = cmd.charAt(j);
                            if (st == -1) {
                                if (code >= '0' && code <= '9') {
                                    st = j;
                                }
                            } else {
                                if (code != '.' && (code < '0' || code > '9')) break;
                                et = j;
                            }
                            ++j;
                        }
                        if ((value = StringUtil.trim(bcmd.substring(st, et + 1))).equals("127.0.0.1")) {
                            ++localCheck;
                        }
                        super.setIpAddress(name, value);
                    }
                    if ((pnt = cmd.indexOf(SUB_NET)) != -1) {
                        lenJ = cmd.length();
                        j = pnt += SUB_NET.length();
                        st = -1;
                        et = -1;
                        while (j < lenJ) {
                            code = cmd.charAt(j);
                            if (st == -1) {
                                if (code >= '0' && code <= '9') {
                                    st = j;
                                }
                            } else {
                                if (code != '.' && (code < '0' || code > '9')) break;
                                et = j;
                            }
                            ++j;
                        }
                        value = StringUtil.trim(bcmd.substring(st, et + 1));
                        super.setSubnetMask(name, value);
                    }
                    if ((pnt = cmd.indexOf(MAC_ADDR)) != -1) {
                        lenJ = cmd.length();
                        j = pnt += MAC_ADDR.length();
                        st = -1;
                        et = -1;
                        while (j < lenJ) {
                            code = cmd.charAt(j);
                            if (st == -1) {
                                if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f') {
                                    st = j;
                                }
                            } else {
                                if (code != ':' && (code < '0' || code > '9') && (code < 'a' || code > 'f')) break;
                                et = j;
                            }
                            ++j;
                        }
                        value = StringUtil.trim(bcmd.substring(st, et + 1)).toUpperCase();
                        super.setMacAddress(name, value);
                    }
                    ++i;
                }
                if (localCheck == 0) {
                    super.setIpAddress("lo", "127.0.0.1");
                    super.setSubnetMask("lo", "255.0.0.0");
                }
            }
            catch (Exception e) {
                this.clear();
                throw e;
            }
        }
        finally {
            cmdOut = null;
            name = null;
            value = null;
        }
    }
}

