/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.util.ArrayList;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final char[] SJIS_MS932_MAP = new char[]{'\u301c', '\uff5e', '\u2016', '\u2225', '\u2212', '\uff0d', '\u00a2', '\uffe0', '\u00a3', '\uffe1', '\u00ac', '\uffe2'};
    public static final int CHECK_NUMBER = 1;
    public static final int CHECK_ALPHABET = 2;
    public static final int CHECK_ASCII = 4;
    public static final int CHECK_KANA = 8;
    public static final int CHECK_HIRA = 16;
    private static final Perl5Util p5util = new Perl5Util();

    public static final ArrayList<String> cutString(String str, String check) throws IllegalArgumentException {
        ArrayList<String> ret = null;
        ret = new ArrayList<String>();
        StringUtil.cutString(ret, false, str, check);
        return ret;
    }

    public static final void cutString(ArrayList<String> out, String str, String check) throws IllegalArgumentException {
        StringUtil.cutString(out, false, str, check);
    }

    public static final ArrayList<String> cutString(boolean mode, String str, String check) throws IllegalArgumentException {
        ArrayList<String> ret = null;
        ret = new ArrayList<String>();
        StringUtil.cutString(ret, mode, str, check);
        return ret;
    }

    public static final void cutString(ArrayList<String> out, boolean mode, String str, String check) throws IllegalArgumentException {
        int len;
        int s = -1;
        char[] checkCode = null;
        String tmp = null;
        if (out == null || str == null || (len = str.length()) <= 0 || check == null || check.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        out.clear();
        int lenJ = check.length();
        checkCode = new char[lenJ];
        check.getChars(0, lenJ, checkCode, 0);
        if (lenJ == 1) {
            int i = 0;
            s = -1;
            while (i < len) {
                char strCode = str.charAt(i);
                int n = s = s == -1 ? i : s;
                if (strCode == checkCode[0]) {
                    if (s < i) {
                        tmp = str.substring(s, i);
                        out.add(tmp);
                        tmp = null;
                        s = -1;
                    } else if (mode) {
                        out.add("");
                        s = -1;
                    } else {
                        s = -1;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            s = -1;
            while (i < len) {
                char strCode = str.charAt(i);
                s = s == -1 ? i : s;
                int j = 0;
                while (j < lenJ) {
                    if (strCode == checkCode[j]) {
                        if (s < i) {
                            tmp = str.substring(s, i);
                            out.add(tmp);
                            tmp = null;
                            s = -1;
                            break;
                        }
                        if (mode) {
                            out.add("");
                            s = -1;
                            break;
                        }
                        s = -1;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (s != -1) {
            tmp = str.substring(s, len);
            out.add(tmp);
            tmp = null;
        }
        checkCode = null;
        tmp = null;
    }

    public static final ArrayList<String> cutString(boolean cote, boolean coteFlg, String str, String check) throws IllegalArgumentException {
        ArrayList<String> ret = null;
        ret = new ArrayList<String>();
        StringUtil.cutString(ret, cote, coteFlg, str, check);
        return ret;
    }

    public static final void cutString(ArrayList<String> out, boolean cote, boolean coteFlg, String str, String check) throws IllegalArgumentException {
        int s = -1;
        char[] checkCode = null;
        String tmp = null;
        if (!cote) {
            StringUtil.cutString(out, str, check);
        } else {
            char coteChr;
            int len;
            if (out == null || str == null || (len = str.length()) <= 0 || check == null || check.length() <= 0) {
                throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
            }
            out.clear();
            int lenJ = check.length();
            checkCode = new char[lenJ];
            check.getChars(0, lenJ, checkCode, 0);
            if (lenJ == 1) {
                int befCode = -1;
                int i = 0;
                s = -1;
                coteChr = '\u0000';
                while (i < len) {
                    char strCode;
                    char nowChr = strCode = str.charAt(i);
                    int n = s = s == -1 ? i : s;
                    if (coteChr == '\u0000') {
                        if (nowChr == '\'' || nowChr == '\"') {
                            coteChr = nowChr;
                            if (s < i) {
                                tmp = str.substring(s, i);
                                out.add(tmp);
                                tmp = null;
                                s = -1;
                            } else {
                                s = -1;
                            }
                        } else if (strCode == checkCode[0]) {
                            if (s < i) {
                                tmp = str.substring(s, i);
                                out.add(tmp);
                                tmp = null;
                                s = -1;
                            } else {
                                s = -1;
                            }
                        }
                    } else if (befCode != 92 && coteChr == nowChr) {
                        coteChr = '\u0000';
                        if (s == i && coteFlg) {
                            out.add("" + strCode + strCode);
                            s = -1;
                        } else if (s < i) {
                            tmp = coteFlg ? str.substring(s - 1, i + 1) : str.substring(s, i);
                            out.add(tmp);
                            tmp = null;
                            s = -1;
                        } else {
                            s = -1;
                        }
                    }
                    befCode = strCode;
                    ++i;
                }
            } else {
                int befCode = -1;
                int i = 0;
                s = -1;
                coteChr = '\u0000';
                while (i < len) {
                    char strCode;
                    char nowChr = strCode = str.charAt(i);
                    int n = s = s == -1 ? i : s;
                    if (coteChr == '\u0000') {
                        if (nowChr == '\'' || nowChr == '\"') {
                            coteChr = nowChr;
                            if (s < i) {
                                tmp = str.substring(s, i);
                                out.add(tmp);
                                tmp = null;
                                s = -1;
                            } else {
                                s = -1;
                            }
                        } else {
                            int j = 0;
                            while (j < lenJ) {
                                if (strCode == checkCode[j]) {
                                    if (s < i) {
                                        tmp = str.substring(s, i);
                                        out.add(tmp);
                                        tmp = null;
                                        s = -1;
                                    } else {
                                        s = -1;
                                    }
                                    break;
                                }
                                ++j;
                            }
                        }
                    } else if (befCode != 92 && coteChr == nowChr) {
                        coteChr = '\u0000';
                        if (s == i && coteFlg) {
                            out.add("" + strCode + strCode);
                            s = -1;
                        } else if (s < i) {
                            tmp = coteFlg ? str.substring(s - 1, i + 1) : str.substring(s, i);
                            out.add(tmp);
                            tmp = null;
                            s = -1;
                        } else {
                            s = -1;
                        }
                    }
                    befCode = strCode;
                    ++i;
                }
            }
            if (s != -1) {
                tmp = coteChr != '\u0000' && coteFlg ? String.valueOf(str.substring(s - 1, len)) + coteChr : str.substring(s, len);
                out.add(tmp);
                tmp = null;
            }
            checkCode = null;
            tmp = null;
        }
    }

    public static final ArrayList<String> parseString(String string, String check) {
        int n = -1;
        int len = string.length();
        ArrayList<String> lst = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        int lenJ = check.length();
        int b = 0;
        boolean end = false;
        int i = 0;
        while (i < len) {
            char c;
            end = false;
            char c2 = string.charAt(i);
            if (c != '\uffffffff') {
                buf.append(c2);
                if (c2 == c && (i != 0 && b != 92 || i == 0)) {
                    c = '\uffffffff';
                }
            } else if ((c2 == '\'' || c2 == '\"') && (i != 0 && b != 92 || i == 0)) {
                buf.append(c2);
                c = c2;
            } else {
                boolean chk = false;
                int j = 0;
                while (j < lenJ) {
                    char x = check.charAt(j);
                    if (c2 == x) {
                        end = true;
                        lst.add(buf.toString().trim());
                        buf = new StringBuilder();
                        chk = true;
                        break;
                    }
                    ++j;
                }
                if (!chk) {
                    buf.append(c2);
                }
            }
            b = c2;
            ++i;
        }
        if (buf.length() > 0 || end) {
            lst.add(buf.toString().trim());
        }
        buf = null;
        return lst;
    }

    public static final int getBefore(String string, int no) {
        if (string == null || string.length() <= 0 || no <= 0) {
            return -1;
        }
        return string.charAt(no - 1) & 0xFFFF;
    }

    public static final int getNext(String string, int no) {
        if (string == null || string.length() <= no + 1) {
            return -1;
        }
        return string.charAt(no + 1) & 0xFFFF;
    }

    public static final int getCount(String string, char check) {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        int ret = 0;
        int n = -1;
        char b = '\u0000';
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c;
            char c2 = string.charAt(i);
            if (c != '\uffffffff') {
                if (c2 == c && (i != 0 && b != '\\' || i == 0)) {
                    c = '\uffffffff';
                }
            } else if ((c2 == '\'' || c2 == '\"') && (i != 0 && b != '\\' || i == 0)) {
                c = c2;
            } else if (check == c2) {
                ++ret;
            }
            b = c2;
            ++i;
        }
        return ret;
    }

    public static final String changeString(String str, String src, String dest) throws IllegalArgumentException {
        int end;
        int srcLen;
        StringBuilder buf = null;
        if (str == null || str.length() <= 0 || src == null || (srcLen = src.length()) <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (dest == null || dest.length() <= 0) {
            dest = "";
        }
        buf = new StringBuilder();
        int pnt = str.indexOf(src);
        if (pnt == -1) {
            return str;
        }
        if (pnt == 0) {
            buf.append(dest);
            end = srcLen;
        } else {
            buf.append(str.substring(0, pnt));
            buf.append(dest);
            end = pnt + srcLen;
        }
        pnt += srcLen;
        while (true) {
            if ((pnt = str.indexOf(src, pnt)) == -1) break;
            if (pnt == end) {
                buf.append(dest);
            } else {
                buf.append(str.substring(end, pnt));
                buf.append(dest);
            }
            end = pnt + srcLen;
            pnt += srcLen;
        }
        buf.append(str.substring(end));
        return buf.toString();
    }

    public static final boolean isCote(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        return (str = str.trim()).startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"");
    }

    public static final String cutCote(String str) {
        if (str == null || str.length() <= 0) {
            if (str == null) {
                return null;
            }
            return "";
        }
        return (str = str.trim()).startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"") ? str.substring(1, str.length() - 1) : str;
    }

    public static final String getNLength(String str, int start, int length) {
        return String.valueOf(str.substring(start, start + length >= str.length() ? str.length() : start + length)) + "...";
    }

    public static final String createString(char chr, int length) {
        if (length <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            buf.append(chr);
            ++i;
        }
        return buf.toString();
    }

    public static final ArrayList<String> getCsv(boolean cote, String line, String cutCode) throws Exception {
        if (line == null || line.length() <= 0) {
            return new ArrayList<String>();
        }
        if (cutCode == null || cutCode.length() <= 0) {
            cutCode = ",";
        }
        ArrayList<String> tmp = new ArrayList<String>();
        int p = -1;
        int b = 0;
        int cutLen = cutCode.length();
        while (true) {
            if ((p = line.indexOf(cutCode, b)) <= -1) {
                if (b == 0) {
                    tmp.add(line);
                    break;
                }
                if (line.length() <= b) break;
                tmp.add(line.substring(b));
                break;
            }
            char c = line.charAt(b);
            if (c == '\'' || c == '\"') {
                int x = line.indexOf(c, b + 1);
                if (x <= -1) {
                    tmp.add(line.substring(b) + c);
                    break;
                }
                tmp.add(line.substring(b, x + 1));
                b = x + 1 + cutLen;
                continue;
            }
            tmp.add(line.substring(b, p));
            b = p + cutLen;
        }
        ArrayList<String> ret = new ArrayList<String>();
        int len = tmp.size();
        int i = 0;
        while (i < len) {
            String x = (String)tmp.get(i);
            if (cote && x.startsWith("'") && x.endsWith("'")) {
                ret.add("\"" + x.substring(1, x.length() - 1) + "\"");
            } else if (!cote && x.startsWith("\"") && x.endsWith("\"")) {
                ret.add("'" + x.substring(1, x.length() - 1) + "'");
            } else {
                ret.add(x);
            }
            ++i;
        }
        tmp.clear();
        tmp = null;
        return ret;
    }

    public static final char toMS932(char c) {
        int len = SJIS_MS932_MAP.length;
        int i = 0;
        while (i < len) {
            if (c == SJIS_MS932_MAP[i]) {
                c = SJIS_MS932_MAP[i + 1];
                break;
            }
            i += 2;
        }
        return c;
    }

    public static final char toSJIS(char c) {
        int len = SJIS_MS932_MAP.length;
        int i = 0;
        while (i < len) {
            if (c == SJIS_MS932_MAP[i + 1]) {
                c = SJIS_MS932_MAP[i];
                break;
            }
            i += 2;
        }
        return c;
    }

    public static final String toMS932(String str) {
        if (str == null) {
            return null;
        }
        char[] c = new char[str.length()];
        int len = str.length();
        int i = 0;
        while (i < len) {
            c[i] = StringUtil.toMS932(str.charAt(i));
            ++i;
        }
        return new String(c);
    }

    public static final String toSJIS(String str) {
        if (str == null) {
            return null;
        }
        char[] c = new char[str.length()];
        int len = str.length();
        int i = 0;
        while (i < len) {
            c[i] = StringUtil.toSJIS(str.charAt(i));
            ++i;
        }
        return new String(c);
    }

    public static final String upIndentCote(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        if (string.indexOf("'") != -1 || string.indexOf("\"") != -1) {
            int len = string.length();
            int yenCnt = 0;
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                int c = string.charAt(i) & 0xFFFF;
                if (c == 39 || c == 34) {
                    if (yenCnt == 0) {
                        buf.append("\\");
                    } else {
                        buf.append("\\\\");
                    }
                }
                buf.append((char)c);
                yenCnt = c == 92 ? ++yenCnt : 0;
                ++i;
            }
            return buf.toString();
        }
        return string;
    }

    public static final String trim(String string) {
        int s = -1;
        int e = -1;
        int len = string.length();
        s = 0;
        boolean sFlg = false;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                s = i;
                break;
            }
            sFlg = true;
            ++i;
        }
        e = len - 1;
        boolean eFlg = false;
        int i2 = len - 1;
        while (i2 >= 0) {
            char c = string.charAt(i2);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                e = i2;
                break;
            }
            eFlg = true;
            --i2;
        }
        if (sFlg && eFlg) {
            return string.substring(s, e + 1);
        }
        if (sFlg) {
            return string.substring(s);
        }
        if (eFlg) {
            return string.substring(0, e + 1);
        }
        return string;
    }

    public static final int indexToNotCote(String base, String cc, int off) throws Exception {
        int len = base.length();
        int n = -1;
        char[] ck = cc.toCharArray();
        int cLen = ck.length;
        int bef = 0;
        int i = off;
        while (i < len) {
            char c;
            char c2 = base.charAt(i);
            if (c != '\uffffffff') {
                if (bef != 92 && c2 == c) {
                    c = '\uffffffff';
                }
            } else if (bef != 92 && (c2 == '\'' || c2 == '\"')) {
                c = c2;
            } else if (c2 == ck[0]) {
                boolean res = true;
                int j = 1;
                while (j < cLen) {
                    if (i + j >= len || ck[j] != base.charAt(i + j)) {
                        res = false;
                        break;
                    }
                    ++j;
                }
                if (res) {
                    return i;
                }
            }
            bef = c2;
            ++i;
        }
        return -1;
    }

    public static final int indexToNotPar(String base, String cc, char st, char ed, int off) throws Exception {
        int len = base.length();
        int par = -1;
        char[] ck = cc.toCharArray();
        int cLen = ck.length;
        int idx = 0;
        int i = off;
        while (i < len) {
            char c = base.charAt(i);
            if (par != -1) {
                if (c == ed) {
                    if (--idx <= 0) {
                        par = -1;
                    }
                } else if (c == st) {
                    ++idx;
                }
            } else if (c == st) {
                idx = 1;
                par = c;
            } else if (c == ck[0]) {
                boolean res = true;
                int j = 1;
                while (j < cLen) {
                    if (i + j >= len || ck[j] != base.charAt(i + j)) {
                        res = false;
                        break;
                    }
                    ++j;
                }
                if (res) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final int indexParAndCote(String base, char st, char ed, int off) throws Exception {
        int len = base.length();
        int par = -1;
        int n = -1;
        int idx = 0;
        int i = off;
        while (i < len) {
            char c;
            char c2 = base.charAt(i);
            if (par != -1 || c != '\uffffffff') {
                if (c != '\uffffffff') {
                    if (c2 == c) {
                        c = '\uffffffff';
                    }
                } else if (par != -1) {
                    if (c2 == ed) {
                        if (--idx <= 0) {
                            return i;
                        }
                    } else if (c2 == st) {
                        ++idx;
                    }
                }
            } else if (c2 == '\'' || c2 == '\"') {
                c = c2;
            } else if (c2 == st) {
                idx = 1;
                par = c2;
            } else if (c2 == ed) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean checkType(int type, String chkString) {
        if (chkString == null || (chkString = chkString.trim()).length() <= 0) {
            return false;
        }
        int len = chkString.length();
        switch (type) {
            case 1: {
                int cnt = 0;
                int i = 0;
                while (i < len) {
                    char c = chkString.charAt(i);
                    if (c < '0' || c > '9') {
                        if (c == '-') {
                            if (i != 0) {
                                return false;
                            }
                        } else if (c == '.') {
                            if (cnt != 0) {
                                return false;
                            }
                            ++cnt;
                        } else {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
            case 2: {
                int i = 0;
                while (i < len) {
                    char c = chkString.charAt(i);
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 4: {
                int i = 0;
                while (i < len) {
                    char c = chkString.charAt(i);
                    if (c > '\u00ff') {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 8: {
                int i = 0;
                while (i < len) {
                    String c = chkString.substring(i, i + 1);
                    if ("\u30a2\u30a3\u30a4\u30a6\u30a6\u30a7\u30a8\u30a9\u30aa\u30ab\u30ac\u30ad\u30ae\u30af\u30b0\u30b1\u30b2\u30b3\u30b4\u30b5\u30b6\u30b7\u30b8\u30b9\u30ba\u30bb\u30bc\u30bd\u30be\u30bf\u30c0\u30c1\u30c2\u30c3\u30c4\u30c5\u30c6\u30c7\u30c8\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d0\u30d1\u30d2\u30d3\u30d4\u30d5\u30d6\u30d7\u30d8\u30d9\u30da\u30db\u30dc\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e3\u30e4\u30e5\u30e6\u30e7\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ee\u30ef\u30f0\u30f2\u30f3\u30fc".indexOf(c) == -1) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 16: {
                int i = 0;
                while (i < len) {
                    String c = chkString.substring(i, i + 1);
                    if ("\u3042\u3043\u3044\u3045\u3046\u3047\u3048\u3049\u304a\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054\u3055\u3056\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e\u305f\u3060\u3061\u3062\u3063\u3064\u3065\u3066\u3067\u3068\u3069\u306a\u306b\u306c\u306d\u306e\u306f\u3070\u3071\u3072\u3073\u3074\u3075\u3076\u3077\u3078\u3079\u307a\u307b\u307c\u307d\u307e\u307f\u3080\u3081\u3082\u3083\u3084\u3085\u3086\u3087\u3088\u3089\u308a\u308b\u308c\u308d\u308e\u308f\u3090\u3091\u3092\u3093\u30fc".indexOf(c) == -1) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isMatch(String match, String src) {
        try {
            if (match == null || match.length() <= 0) {
                return false;
            }
            if (src == null || (src = src.trim()).length() <= 0) {
                return false;
            }
            return !p5util.match(match, src);
        }
        catch (Exception e) {
            return true;
        }
    }
}

