/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.InputStream;

public class RunProcess {
    private String[] cmd = null;
    private Process process = null;

    private RunProcess() {
    }

    public RunProcess(String[] cmd) {
        if (cmd == null || cmd.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.cmd = cmd;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.process != null) {
            try {
                this.process.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.process.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.process.getErrorStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cmd = null;
        this.process = null;
    }

    public InputStream execution() throws Exception {
        if (this.cmd == null || this.cmd.length <= 0) {
            throw new IllegalArgumentException("\u30b3\u30de\u30f3\u30c9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            this.process = Runtime.getRuntime().exec(this.cmd);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
        return this.process.getInputStream();
    }

    public int waitFor() throws Exception {
        if (this.process != null) {
            return this.process.waitFor();
        }
        return -1;
    }
}

