/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

public class BinaryBuffer {
    private static final int BUFFER = 1024;
    private byte[] binary = null;
    private int pos = 0;

    public BinaryBuffer() {
        this(-1);
    }

    public BinaryBuffer(int size) {
        if (size <= 0) {
            size = 1024;
        }
        this.binary = new byte[size];
        this.pos = 0;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.binary = null;
        this.pos = 0;
    }

    public int position(int pos) {
        if (pos <= -1) {
            return this.pos;
        }
        if (this.binary.length < pos) {
            this.addLimit(pos - this.binary.length);
            this.pos = pos;
        } else {
            this.pos = pos;
        }
        return this.pos;
    }

    public int position() {
        return this.pos;
    }

    public void write(int b) throws Exception {
        this.addLimit(1);
        this.binary[this.pos] = (byte)(b & 0xFF);
        ++this.pos;
    }

    public void write(byte[] bin) throws Exception {
        if (bin == null || bin.length <= 0) {
            return;
        }
        this.write(bin, -1);
    }

    public void write(byte[] bin, int len) throws Exception {
        if (bin == null || bin.length <= 0) {
            return;
        }
        if (len <= 0 || bin.length <= len) {
            len = bin.length;
        }
        this.addLimit(len);
        int off = this.pos;
        System.arraycopy(bin, 0, this.binary, off, len);
        this.pos += len;
    }

    public byte getByte(int no) {
        return this.binary[no];
    }

    public byte[] getRawBinary() {
        return this.binary;
    }

    public byte[] getBinary() {
        return this.getBinary(0);
    }

    public byte[] getBinary(int length) {
        if (length > this.binary.length) {
            return this.binary;
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.binary, 0, ret, 0, length);
        return ret;
    }

    private void addLimit(int len) {
        if (this.binary.length <= this.pos + len) {
            byte[] t = this.binary;
            int iLen = t.length * 2 + len;
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
    }
}

