/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shutdown;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.maachang.shutdown.SendShutdown;

public class WaitShutdown {
    private static final int RECEIVE_TIMEOUT = 5000;
    private DatagramSocket connection = null;
    private int srcPort = -1;

    private WaitShutdown() {
    }

    public WaitShutdown(int port) throws Exception {
        if (port <= 0 || port > 65535) {
            port = 3331;
        }
        this.connection = new DatagramSocket(port, InetAddress.getByName("127.0.0.1"));
        this.connection.setSoTimeout(5000);
    }

    public boolean isShutdown() {
        boolean ret = false;
        try {
            DatagramPacket packet = new DatagramPacket(new byte[512], 512);
            this.connection.receive(packet);
            if (packet.getLength() == SendShutdown.SHUTDOWN_BINARY.length && WaitShutdown.equals(packet)) {
                this.srcPort = packet.getPort();
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public void exitShutdown() {
        if (this.srcPort > 0) {
            try {
                this.connection.send(new DatagramPacket(SendShutdown.SHUTDOWN_BINARY, 0, SendShutdown.SHUTDOWN_BINARY.length, InetAddress.getByName("127.0.0.1"), this.srcPort));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final boolean equals(DatagramPacket packet) {
        if (packet.getLength() == SendShutdown.SHUTDOWN_BINARY.length) {
            boolean ret = true;
            int len = packet.getLength();
            byte[] bin = packet.getData();
            int i = 0;
            while (i < len) {
                if ((SendShutdown.SHUTDOWN_BINARY[i] & 0xFF) != (bin[i] & 0xFF)) {
                    ret = false;
                    break;
                }
                ++i;
            }
            return ret;
        }
        return false;
    }
}

