/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import org.maachang.connector.ConnectorAcceptThread;
import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorManager;
import org.maachang.connector.ConnectorPoolThread;
import org.maachang.connector.ConnectorQueue;
import org.maachang.connector.ConnectorReceiveThread;

public class ConnectorService {
    private static final int RECV_THREAD = 3;
    private ConnectorAcceptThread accept = null;
    private ConnectorReceiveThread[] receive = null;
    private ConnectorPoolThread[] pool = null;

    private ConnectorService() {
    }

    public ConnectorService(byte[] headerBinary, ConnectorCallback callback, ConnectorManager manager, int poolLen) throws Exception {
        if (callback == null || manager.isClosed() || poolLen <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ConnectorQueue rq = new ConnectorQueue();
        ConnectorAcceptThread ac = new ConnectorAcceptThread(headerBinary, manager);
        ConnectorReceiveThread[] rc = new ConnectorReceiveThread[3];
        int i = 0;
        while (i < 3) {
            rc[i] = new ConnectorReceiveThread(manager, rq);
            ++i;
        }
        ConnectorPoolThread[] pt = new ConnectorPoolThread[poolLen];
        int i2 = 0;
        while (i2 < poolLen) {
            pt[i2] = new ConnectorPoolThread(headerBinary, manager, callback, rq);
            ++i2;
        }
        this.accept = ac;
        this.receive = rc;
        this.pool = pt;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        int i;
        int len;
        if (this.pool != null) {
            len = this.pool.length;
            i = 0;
            while (i < len) {
                if (this.pool[i] != null) {
                    this.pool[i].destroy();
                }
                this.pool[i] = null;
                ++i;
            }
            this.pool = null;
        }
        if (this.receive != null) {
            len = this.receive.length;
            i = 0;
            while (i < len) {
                if (this.receive[i] != null) {
                    this.receive[i].destroy();
                }
                this.receive[i] = null;
                ++i;
            }
            this.receive = null;
        }
        if (this.accept != null) {
            this.accept.destroy();
            this.accept = null;
        }
    }
}

