/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.conf;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.conf.ConvIniParam;
import org.maachang.conf.ReadConfigUtil;

public class Config {
    private HashMap<String, HashMap<String, ArrayList<String>>> params = new HashMap();
    private HashMap<String, ArrayList<String>> keyByNum = new HashMap();

    public static final Config read(String name) throws Exception {
        Config ret = new Config();
        ReadConfigUtil.readConfig(ret, name);
        return ret;
    }

    public synchronized void clear() {
        this.params.clear();
        this.keyByNum.clear();
    }

    public synchronized void put(String section, String key, String value) {
        ArrayList<String> keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        ArrayList<String> keys = this.keyByNum.get(section);
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new HashMap();
            this.params.put(section, sectionValue);
            keys = new ArrayList();
            this.keyByNum.put(section, keys);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new ArrayList();
            sectionValue.put(key, keyValue);
            keys.add(key);
        }
        keyValue.add(value);
    }

    public synchronized void set(String section, String key, String value) {
        ArrayList<String> keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new HashMap();
            this.params.put(section, sectionValue);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new ArrayList();
            sectionValue.put(key, keyValue);
        } else {
            keyValue.clear();
        }
        keyValue.add(value);
    }

    public synchronized String get(String section, String key, int no) {
        ArrayList<String> value;
        if (section == null || key == null || no < 0) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > no) {
            return value.get(no);
        }
        return null;
    }

    public synchronized boolean getBoolean(String section, String key, int no) {
        return ConvIniParam.getBoolean(this.get(section, key, no));
    }

    public synchronized Boolean getBooleanObject(String section, String key, int no) {
        Boolean ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Boolean(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public synchronized int getInt(String section, String key, int no) {
        return ConvIniParam.getInt(this.get(section, key, no));
    }

    public synchronized Integer getIntObject(String section, String key, int no) {
        Integer ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Integer(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public synchronized long getLong(String section, String key, int no) {
        return ConvIniParam.getLong(this.get(section, key, no));
    }

    public synchronized Long getLongObject(String section, String key, int no) {
        Long ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Long(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public synchronized double getDouble(String section, String key, int no) {
        return ConvIniParam.getDouble(this.get(section, key, no));
    }

    public synchronized Double getDoubleObject(String section, String key, int no) {
        Double ret = null;
        String s = this.get(section, key, no);
        if (s != null) {
            try {
                ret = new Double(s);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public synchronized InetAddress getInetAddress(String section, String key, int no) {
        return ConvIniParam.getInetAddress(this.get(section, key, no));
    }

    public synchronized String[] getAll(String section, String key) {
        ArrayList<String> value;
        if (section == null || key == null) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > 0) {
            int len = value.size();
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = value.get(i);
                ++i;
            }
            return ret;
        }
        return null;
    }

    public synchronized void removeSection(String section) {
        if (section == null) {
            return;
        }
        this.params.remove(section);
        this.keyByNum.remove(section);
    }

    public synchronized void removeKey(String section, String key) {
        if (section == null || key == null) {
            return;
        }
        section = section.trim();
        key = key.trim();
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section);
        if (sectionValue != null) {
            sectionValue.remove(key);
            ArrayList<String> keys = this.keyByNum.get(section);
            if (keys != null && keys.size() > 0) {
                int len = keys.size();
                int i = 0;
                while (i < len) {
                    if (key.equals(keys.get(i))) {
                        keys.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public synchronized int size(String section, String key) {
        ArrayList<String> value;
        if (section == null || key == null) {
            return -1;
        }
        section = section.trim();
        key = key.trim();
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null) {
            return value.size();
        }
        return -1;
    }

    public synchronized int size(String section) {
        if (section == null) {
            return -1;
        }
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.size();
        }
        return -1;
    }

    public synchronized int size() {
        return this.params.size();
    }

    public synchronized String[] getKeys(String section) {
        if (section == null) {
            return null;
        }
        section = section.trim();
        ArrayList<String> keys = this.keyByNum.get(section);
        String[] ret = null;
        if (keys != null && keys.size() > 0) {
            int len = keys.size();
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = keys.get(i);
                ++i;
            }
        }
        return ret;
    }

    public synchronized Object[] getSections() {
        if (this.params != null && this.params.size() > 0) {
            return this.params.keySet().toArray();
        }
        return null;
    }

    public synchronized boolean isKeys(String section, String key) {
        if (section == null) {
            return false;
        }
        HashMap<String, ArrayList<String>> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.get(key) != null;
        }
        return false;
    }

    public synchronized boolean isSection(String section) {
        return this.params.get(section = section.trim()) != null;
    }

    public synchronized String toString() {
        if (this.params != null && this.params.size() > 0) {
            StringBuilder buf = new StringBuilder();
            Object[] objs = this.params.keySet().toArray();
            int len = objs.length;
            int i = 0;
            while (i < len) {
                buf.append("[").append(objs[i]).append("]\n");
                HashMap<String, ArrayList<String>> key = this.params.get(objs[i]);
                if (key != null && key.size() > 0) {
                    Object[] sObjs = key.keySet().toArray();
                    int lenJ = sObjs.length;
                    int j = 0;
                    while (j < lenJ) {
                        buf.append("  ").append(sObjs[j]).append("\n");
                        ArrayList<String> emt = key.get(sObjs[j]);
                        if (emt != null && emt.size() > 0) {
                            int lenK = emt.size();
                            buf.append("    ");
                            int k = 0;
                            while (k < lenK) {
                                if (k != 0) {
                                    buf.append(",");
                                }
                                buf.append(emt.get(k));
                                ++k;
                            }
                            buf.append("\n");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

