/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;

class DbcpPooling {
    private static final int CHK_NO_CONNECTION_BY_COUNT = 3;
    private static final long CHK_NO_CONNECTION_BY_TIME = 30000L;
    private static final int PS_SIZE = 3;
    private ObjectPool pool = null;
    private DataSource dataSouce = null;

    private DbcpPooling() {
    }

    private static final ObjectPool getObjectPool(String driver, String url, String user, String passwd, long keepAlive, int max, String checkSQL, boolean readOnly, boolean autoCommit) throws Exception {
        if (driver == null || (driver = driver.trim()).length() <= 0 || url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        user = user == null || (user = user.trim()).length() <= 0 ? null : user;
        passwd = passwd == null || (passwd = passwd.trim()).length() <= 0 ? null : passwd;
        checkSQL = checkSQL == null || (checkSQL = checkSQL.trim()).length() <= 0 ? null : checkSQL;
        int chkCount = -1;
        if (keepAlive <= -1L) {
            chkCount = 3 >= max ? max : 3;
        }
        Class.forName(driver, true, DriverManagerConnectionFactory.class.getClassLoader());
        GenericObjectPool pool = new GenericObjectPool(null, max, 2, -1L, max, 0, true, true, 30000L, chkCount, keepAlive, false);
        DriverManagerConnectionFactory conFactory = new DriverManagerConnectionFactory(url, user, passwd);
        StackKeyedObjectPoolFactory psFactory = new StackKeyedObjectPoolFactory(max * 3, max);
        new PoolableConnectionFactory((ConnectionFactory)conFactory, (ObjectPool)pool, (KeyedObjectPoolFactory)psFactory, checkSQL, readOnly, autoCommit);
        return pool;
    }

    public DbcpPooling(String driver, String url, String user, String passwd, long keepAlive, int max, String checkSQL, boolean readOnly, boolean autoCommit) throws Exception {
        this.pool = DbcpPooling.getObjectPool(driver, url, user, passwd, keepAlive, max, checkSQL, readOnly, autoCommit);
        this.dataSouce = new PoolingDataSource(this.pool);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pool = null;
        this.dataSouce = null;
    }

    public Connection getConnection() throws Exception {
        return this.dataSouce.getConnection();
    }

    public int max() {
        return ((GenericObjectPool)this.pool).getMaxActive();
    }

    public int active() {
        return this.pool.getNumActive();
    }

    public int idle() {
        return this.pool.getNumIdle();
    }
}

