/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.util.HashMap;
import org.maachang.dao.dbms.pool.ConnectManager;
import org.maachang.dao.dbms.pool.DbcpPooling;

public class ConnectPoolFactory {
    private final HashMap<String, DbcpPooling> connectManager = new HashMap();
    private static final ConnectPoolFactory SNGL = new ConnectPoolFactory();
    private final Object sync = new Object();

    private ConnectPoolFactory() {
    }

    public static final ConnectPoolFactory getInstance() {
        return SNGL;
    }

    public void clear() {
        this.connectManager.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, String driver, String url, String user, String passwd, long keepAlive, int max, String checkSQL, boolean readOnly, boolean autoCommit) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9aurl\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.connectManager.get(name) != null) {
                throw new IllegalArgumentException("\u6307\u5b9a\u540d[" + name + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            DbcpPooling obj = new DbcpPooling(driver, url, user, passwd, keepAlive, max, checkSQL, readOnly, autoCommit);
            this.connectManager.put(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.connectManager.get(name) != null) {
                this.connectManager.remove(name);
            }
        }
    }

    public static ConnectManager get(String driver, String url, String user, String passwd, long keepAlive, int max, String checkSQL, boolean readOnly, boolean autoCommit) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9aurl\u306f\u4e0d\u6b63\u3067\u3059");
        }
        DbcpPooling obj = new DbcpPooling(driver, url, user, passwd, keepAlive, max, checkSQL, readOnly, autoCommit);
        return new ConnectManager(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectManager get(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        DbcpPooling man = null;
        Object object = this.sync;
        synchronized (object) {
            man = this.connectManager.get(name);
        }
        ConnectManager ret = null;
        if (man != null) {
            try {
                ret = new ConnectManager(man);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames() {
        String[] ret = null;
        Object[] objs = null;
        Object object = this.sync;
        synchronized (object) {
            int len = this.connectManager.size();
            if (len > 0) {
                objs = this.connectManager.keySet().toArray();
            }
        }
        if (objs != null) {
            int len = objs.length;
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)objs[i];
                objs[i] = null;
                ++i;
            }
            objs = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = this.connectManager.size();
        }
        return ret;
    }
}

