/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.maachang.dao.DaoSession;
import org.maachang.dao.DaoSessionFactory;
import org.maachang.dao.DeleteJoinPlugin;
import org.maachang.dao.ExecutionDao;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.OptimisticLockException;
import org.maachang.dao.ResultLine;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.RecordSequenceId;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaachangDao {
    private final String VERSION = "1.11";
    private static final MaachangDao SNGL = new MaachangDao();
    private static final String MANY_JOIN_NAME = "$";

    private MaachangDao() {
    }

    public static final MaachangDao getInstance() {
        return SNGL;
    }

    public String getVersion() {
        return "1.11";
    }

    public Map<String, Object> save(DaoSession session, String modelName, Map<String, Object> model) throws MaachangDaoException {
        if (session == null || model == null || model.size() <= 0 || modelName == null || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (model == null || model.size() <= 0) {
                throw new MaachangDaoException("\u4fdd\u5b58\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            boolean idFlag = ExecutionDao.isSequence(meta);
            if (this.isEntry(record, idFlag, meta, model, modelName)) {
                StringBuilder buf = new StringBuilder();
                buf.append("update ").append(meta.getTable()).append(" set ");
                int len = meta.size();
                int cnt = 0;
                ObjectArray pms = new ObjectArray();
                int i = 0;
                while (i < len) {
                    String column = meta.getColumnName(i);
                    String javaName = DbUtil.convertDBNameByJavaName(false, column);
                    if (!"id".equals(column)) {
                        Object value = null;
                        if ("update_time".equals(column)) {
                            value = new Timestamp(System.currentTimeMillis());
                            model.put(javaName, value);
                        } else {
                            value = model.get(javaName);
                        }
                        if (value != null) {
                            if (cnt != 0) {
                                buf.append(",");
                            }
                            buf.append(column).append("=").append("?");
                            pms.add(value);
                            ++cnt;
                        }
                    }
                    ++i;
                }
                buf.append(" where id=?");
                if (pms.size() <= 0) {
                    throw new IllegalArgumentException("\u4fdd\u5b58\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5168\u3066NULL\u3067\u3059");
                }
                String sql = buf.toString();
                buf = null;
                Object id = model.get("id");
                pms.add(id);
                ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, pms);
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("insert into ").append(meta.getTable()).append(" (");
                int len = meta.size();
                ObjectArray pms = new ObjectArray();
                boolean addId = false;
                if (idFlag) {
                    RecordSequenceId reqId = DaoSessionFactory.getInstance().getJavaSequence();
                    Object id = model.get("id");
                    if (id != null) {
                        if (id instanceof Long) {
                            if (reqId != null) {
                                reqId.setId(modelName, (Long)id);
                            }
                            addId = true;
                        } else {
                            pms.add(new Object());
                            model.remove("id");
                            addId = true;
                        }
                    } else if (reqId != null) {
                        pms.add((Object)new Long(reqId.getId(modelName)));
                        addId = true;
                    } else if (record.isSequence()) {
                        pms.add(new Object());
                        addId = true;
                    }
                    if (addId) {
                        buf.append("id");
                        if (len != 1) {
                            buf.append(",");
                        }
                    }
                }
                int cnt = 0;
                int i = 0;
                while (i < len) {
                    String column = meta.getColumnName(i);
                    int type = meta.getColumnType(i);
                    String lowerColumn = column.toLowerCase();
                    String javaName = DbUtil.convertDBNameByJavaName(false, column);
                    if (!"id".equals(column)) {
                        Object value = null;
                        if ("create_time".equals(lowerColumn) || "update_time".equals(lowerColumn)) {
                            value = new Timestamp(System.currentTimeMillis());
                            model.put(javaName, value);
                        } else if ("optimistic_lock".equals(lowerColumn) && -5 == type) {
                            value = new Long(1L);
                            model.put(javaName, value);
                        } else {
                            value = model.get(javaName);
                        }
                        if (cnt != 0) {
                            buf.append(",");
                        }
                        buf.append(column);
                        if (value == null) {
                            pms.add(null);
                        } else {
                            pms.add(value);
                        }
                        ++cnt;
                    }
                    ++i;
                }
                buf.append(") values (");
                if (addId) {
                    if (cnt == 0) {
                        buf.append("?)");
                    } else {
                        buf.append("?,");
                    }
                }
                i = 0;
                while (i < cnt) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    buf.append("?");
                    ++i;
                }
                buf.append(")");
                String sql = buf.toString();
                Long[] resId = new Long[1];
                ExecutionDao.execution(null, resId, record, modelName, meta, sql, -1, -1, pms);
                if (addId && resId[0] != null && resId[0] instanceof Long) {
                    model.put("id", resId[0]);
                }
            }
            return model;
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public void update(DaoSession session, String modelName, String set, Object ... params) throws MaachangDaoException {
        if (session == null || set == null || modelName == null || (set = set.trim()).length() <= 0 || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (set == null || set.length() <= 0) {
                throw new MaachangDaoException("Set\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            StringBuilder buf = new StringBuilder();
            if (!set.toLowerCase().startsWith("set ")) {
                buf.append("update ").append(meta.getTable()).append(" set ").append(set);
            } else {
                buf.append("update ").append(meta.getTable()).append(" ").append(set);
            }
            String sql = buf.toString();
            buf = null;
            if (ExecutionDao.isUpdateTime(meta)) {
                boolean[] addFlag = new boolean[1];
                sql = MaachangDao.addUpdateTime(addFlag, sql);
                if (addFlag[0]) {
                    params = MaachangDao.addUpdateTimeParam(params);
                }
            }
            ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, params);
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public void delete(DaoSession session, DeleteJoinPlugin plugin, ArrayList<String> deleteJoinColumns, Map<String, List<String>> srcJoin, String modelName, Map<String, Object> model) throws MaachangDaoException {
        if (session == null || modelName == null || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            if (ExecutionDao.isSequence(meta)) {
                Object id = model.get("id");
                if (id == null) {
                    throw new IllegalArgumentException("ID\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                MaachangDao.executionDeleteJoinPlugin(session, modelName, plugin, deleteJoinColumns, "where id=?", id);
                MaachangDao.deleteBySrcJoin(session, srcJoin, modelName, "where id=?", id);
                StringBuilder buf = new StringBuilder();
                buf.append("delete from ").append(meta.getTable()).append(" where id=?;");
                String sql = buf.toString();
                buf = null;
                ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, new Object[]{id});
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("delete from ").append(meta.getTable()).append(" where ");
                int len = meta.size();
                ObjectArray pms = new ObjectArray();
                int i = 0;
                while (i < len) {
                    String column;
                    Object value;
                    if (i != 0) {
                        buf.append(" and ");
                    }
                    if ((value = model.get(DbUtil.convertDBNameByJavaName(false, column = meta.getColumnName(i)))) == null) {
                        buf.append(column).append(" is null");
                    } else {
                        buf.append(column).append("=?");
                        pms.add(value);
                    }
                    ++i;
                }
                if (pms.size() <= 0) {
                    pms = null;
                }
                String sql = buf.toString();
                buf = null;
                ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, pms);
            }
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public void delete(DaoSession session, DeleteJoinPlugin plugin, ArrayList<String> deleteJoinColumns, Map<String, List<String>> srcJoin, String modelName, String where, Object ... params) throws MaachangDaoException {
        if (session == null || modelName == null || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            MaachangDao.executionDeleteJoinPlugin(session, modelName, plugin, deleteJoinColumns, where, params);
            MaachangDao.deleteBySrcJoin(session, srcJoin, modelName, where, params);
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            StringBuilder buf = new StringBuilder();
            if (where == null || (where = where.trim()).length() <= 0) {
                buf.append("delete from ").append(meta.getTable());
                params = null;
            } else {
                buf.append("delete from ").append(meta.getTable()).append(" ").append(where);
            }
            String sql = buf.toString();
            buf = null;
            ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, params);
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public List<Map<String, Object>> find(DaoSession session, Map<String, String> join, Map<String, List<String>> srcJoin, String modelName, String where, Object ... params) throws MaachangDaoException {
        return this.find(session, join, srcJoin, modelName, where, -1, -1, params);
    }

    public List<Map<String, Object>> find(DaoSession session, Map<String, String> join, Map<String, List<String>> srcJoin, String modelName, String where, int offset, int limit, Object ... params) throws MaachangDaoException {
        if (session == null || modelName == null || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            String sql = null;
            if (where == null || (where = where.trim()).length() <= 0) {
                sql = "select * from " + meta.getTable();
                params = null;
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("select * from ").append(meta.getTable()).append(" ").append(where);
                sql = buf.toString();
                buf = null;
            }
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            ExecutionDao.execution(ret, null, record, modelName, meta, sql, offset, limit, params);
            MaachangDao.findByJoin(ret, session, join);
            MaachangDao.findByMany(ret, session, srcJoin);
            return ret;
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public void readLine(ResultLine out, DaoSession session, String modelName, String where, Object ... params) throws MaachangDaoException {
        if (out == null) {
            throw new MaachangDaoException("\u623b\u308a\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (session == null || modelName == null || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            ResultSet rs = null;
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            String sql = null;
            if (where == null || (where = where.trim()).length() <= 0) {
                sql = "select * from " + meta.getTable();
                params = null;
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("select * from ").append(meta.getTable()).append(" ").append(where);
                sql = buf.toString();
                buf = null;
            }
            SupportKind kind = record.getSupportKind();
            if (kind == null) {
                throw new MaachangDaoException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
            }
            rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params);
            out.create(modelName, rs, meta);
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public int count(DaoSession session, String modelName) throws MaachangDaoException {
        return this.count(session, modelName, null, null);
    }

    public int count(DaoSession session, String modelName, String where, Object ... params) throws MaachangDaoException {
        if (session == null || modelName == null || (modelName = modelName.trim()).length() <= 0) {
            if (session == null) {
                throw new MaachangDaoException("\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new MaachangDaoException("\u30e2\u30c7\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            Record record = session.getRecord();
            MetaColumn meta = session.getMeta(modelName);
            String sql = null;
            if (where == null || (where = where.trim()).length() <= 0) {
                sql = "select count(*) from " + meta.getTable();
                params = null;
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("select count(*) from ").append(meta.getTable()).append(" ").append(where);
                sql = buf.toString();
                buf = null;
            }
            return ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, params);
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    private boolean isEntry(Record record, boolean idFlag, MetaColumn meta, Map<String, Object> model, String modelName) throws Exception {
        if (!idFlag) {
            return false;
        }
        Object value = model.get("id");
        if (value == null) {
            return false;
        }
        if (ExecutionDao.isOptimisticLock(meta)) {
            StringBuilder buf = new StringBuilder();
            buf.append("select ").append("optimistic_lock").append(" from ").append(DbUtil.convertJavaNameByDBName(modelName)).append(" where id=?");
            String sql = buf.toString();
            buf = null;
            ResultSet rs = null;
            String optimisticLockKey = DbUtil.convertDBNameByJavaName(false, "optimistic_lock");
            Long optimisticLockValue = MaachangDao.convertObjectByLong(model.get(optimisticLockKey));
            try {
                boolean ret = false;
                rs = record.executeQuery(sql, new Object[]{value});
                if (rs != null) {
                    if (rs.next()) {
                        if (optimisticLockValue != null) {
                            if (!optimisticLockValue.equals(rs.getLong("optimistic_lock"))) {
                                throw new OptimisticLockException("[" + modelName + "] - use optimistic lock.(src:" + optimisticLockValue + " now:" + rs.getLong("optimistic_lock") + ")");
                            }
                            optimisticLockValue = new Long(optimisticLockValue + 1L);
                            model.put(optimisticLockKey, optimisticLockValue);
                        } else {
                            model.put(optimisticLockKey, new Long(1L));
                        }
                        ret = true;
                    }
                    rs.close();
                    rs = null;
                }
                boolean bl = ret;
                return bl;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) from ").append(DbUtil.convertJavaNameByDBName(modelName)).append(" where id=?");
        String sql = buf.toString();
        buf = null;
        ResultSet rs = null;
        try {
            boolean ret = false;
            rs = record.executeQuery(sql, new Object[]{value});
            if (rs != null) {
                if (rs.next()) {
                    ret = true;
                }
                rs.close();
                rs = null;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final String addUpdateTime(boolean[] addFlag, String sql) throws Exception {
        addFlag[0] = false;
        String lower = sql.toLowerCase();
        int s = lower.indexOf(" set ");
        int e = lower.indexOf(" where ");
        if (s == -1) {
            return sql;
        }
        if (e == -1) {
            e = lower.length();
        }
        int x = lower.indexOf(" update_time", s += " set ".length());
        int y = lower.indexOf(",update_time", s);
        if (x == -1 || x > y) {
            x = y;
        }
        lower = null;
        if (x == -1 || x > e) {
            sql = sql.substring(0, s) + "update_time" + " =?, " + sql.substring(s, sql.length());
            addFlag[0] = true;
        }
        return sql;
    }

    private static final Object[] addUpdateTimeParam(Object[] params) throws Exception {
        Object[] ret = null;
        if (params == null || params.length <= 0) {
            ret = new Object[1];
        } else {
            int len = params.length;
            ret = new Object[len + 1];
            System.arraycopy(params, 0, ret, 1, len);
        }
        ret[0] = new Timestamp(System.currentTimeMillis());
        return ret;
    }

    private static final void findByJoin(List<Map<String, Object>> out, DaoSession session, Map<String, String> join) throws Exception {
        if (join == null || join.size() <= 0 || out == null || out.size() <= 0) {
            return;
        }
        int len = out.size();
        int lenJ = join.size();
        Object[] names = join.keySet().toArray();
        int i = 0;
        while (i < len) {
            Map<String, Object> o = out.get(i);
            int j = 0;
            while (j < lenJ) {
                String column = (String)names[j];
                String table = join.get(column);
                Object id = o.get(column);
                if (id != null) {
                    Map<String, Object> value = MaachangDao.getTableById(session, table, id);
                    o.put(column, value);
                }
                ++j;
            }
            ++i;
        }
    }

    private static final Map<String, Object> getTableById(DaoSession session, String modelName, Object id) throws Exception {
        Record record = session.getRecord();
        MetaColumn meta = session.getMeta(modelName);
        String sql = "select * from " + meta.getTable() + " where id=?";
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        ExecutionDao.execution(ret, null, record, modelName, meta, sql, 0, 1, new Object[]{id});
        if (ret.size() <= 0) {
            return null;
        }
        return ret.get(0);
    }

    private static final void findByMany(List<Map<String, Object>> out, DaoSession session, Map<String, List<String>> srcJoin) throws Exception {
        if (srcJoin == null || srcJoin.size() <= 0 || out == null || out.size() <= 0) {
            return;
        }
        if (out != null && out.size() > 0) {
            int len = out.size();
            int lenJ = srcJoin.size();
            Object[] names = srcJoin.keySet().toArray();
            int i = 0;
            while (i < len) {
                Map<String, Object> o = out.get(i);
                Object id = o.get("id");
                if (id != null) {
                    int j = 0;
                    while (j < lenJ) {
                        String table = (String)names[j];
                        List<String> columns = srcJoin.get(table);
                        if (columns != null && columns.size() > 0) {
                            int lenK = columns.size();
                            table = DbUtil.convertJavaNameByDBName(table);
                            int k = 0;
                            while (k < lenK) {
                                String column = columns.get(k);
                                if (column != null && (column = column.trim()).length() > 0) {
                                    column = DbUtil.convertJavaNameByDBName(column);
                                    ArrayList<Map<String, Object>> res = MaachangDao.getTableByMany(session, table, column, id);
                                    String manyName = MANY_JOIN_NAME + DbUtil.convertDBNameByJavaName(true, table) + "_" + DbUtil.convertDBNameByJavaName(false, column);
                                    o.put(manyName, res);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static final ArrayList<Map<String, Object>> getTableByMany(DaoSession session, String modelName, String column, Object id) throws Exception {
        Record record = session.getRecord();
        MetaColumn meta = session.getMeta(modelName);
        String sql = "select * from " + meta.getTable() + (" where " + column + "=?");
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        ExecutionDao.execution(ret, null, record, modelName, meta, sql, 0, Integer.MAX_VALUE, new Object[]{id});
        return ret;
    }

    private static final void deleteBySrcJoin(DaoSession session, Map<String, List<String>> srcJoin, String modelName, String where, Object ... params) throws Exception {
        if (srcJoin == null || srcJoin.size() <= 0) {
            return;
        }
        Record record = session.getRecord();
        MetaColumn meta = session.getMeta(modelName);
        String sql = null;
        if (where == null || (where = where.trim()).length() <= 0) {
            sql = "select id from " + meta.getTable();
            params = null;
        } else {
            sql = "select id from " + meta.getTable() + " " + where;
        }
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>();
        ExecutionDao.execution(out, null, record, modelName, meta, sql, 0, Integer.MAX_VALUE, params);
        if (out != null && out.size() > 0) {
            int len = out.size();
            int lenJ = srcJoin.size();
            Object[] names = srcJoin.keySet().toArray();
            int i = 0;
            while (i < len) {
                Map<String, Object> o = out.get(i);
                Object id = o.get("id");
                if (id != null) {
                    int j = 0;
                    while (j < lenJ) {
                        String table = (String)names[j];
                        List<String> columns = srcJoin.get(table);
                        if (columns != null && columns.size() > 0) {
                            int lenK = columns.size();
                            table = DbUtil.convertJavaNameByDBName(table);
                            int k = 0;
                            while (k < lenK) {
                                String column = columns.get(k);
                                if (column != null && (column = column.trim()).length() > 0) {
                                    column = DbUtil.convertJavaNameByDBName(column);
                                    MaachangDao.removeTableById(session, table, column, id);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static final void executionDeleteJoinPlugin(DaoSession session, String modelName, DeleteJoinPlugin plugin, ArrayList<String> deleteJoinColumn, String where, Object ... params) throws Exception {
        if (plugin == null || deleteJoinColumn == null || deleteJoinColumn.size() <= 0) {
            return;
        }
        Record record = session.getRecord();
        MetaColumn meta = session.getMeta(modelName);
        String sql = null;
        if (where == null || (where = where.trim()).length() <= 0) {
            sql = "select" + MaachangDao.convertArrayListByString(deleteJoinColumn) + "from " + meta.getTable();
            params = null;
        } else {
            sql = "select" + MaachangDao.convertArrayListByString(deleteJoinColumn) + "from " + meta.getTable() + " " + where;
        }
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>();
        ExecutionDao.execution(out, null, record, modelName, meta, sql, 0, Integer.MAX_VALUE, params);
        if (out.size() > 0) {
            int len = out.size();
            int lenJ = deleteJoinColumn.size();
            int i = 0;
            while (i < len) {
                Map<String, Object> o = out.get(i);
                if (o != null) {
                    int j = 0;
                    while (j < lenJ) {
                        Object id = o.get(deleteJoinColumn.get(j));
                        if (id != null && id instanceof Long) {
                            long idLong = (Long)id;
                            plugin.remove(idLong);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static final void removeTableById(DaoSession session, String modelName, String column, Object id) throws Exception {
        Record record = session.getRecord();
        MetaColumn meta = session.getMeta(modelName);
        String sql = "delete from " + meta.getTable() + (" where " + column + "=?");
        ExecutionDao.execution(null, null, record, modelName, meta, sql, -1, -1, new Object[]{id});
    }

    private static final String convertArrayListByString(ArrayList<String> lst) {
        int len = lst.size();
        StringBuilder buf = new StringBuilder();
        buf.append(" ");
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(DbUtil.convertJavaNameByDBName(lst.get(i)));
            ++i;
        }
        buf.append(" ");
        return buf.toString();
    }

    private static final Long convertObjectByLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new Long((String)o);
        }
        if (o instanceof Integer) {
            return new Long(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return new Long(o.toString());
    }
}

