/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.net.ServerSocket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.nio.NioSslReceiveServerArray;
import org.maachang.comet.net.nio.NioSslUtil;
import org.maachang.comet.net.nio.NioTcpUtil;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.comet.net.ssl.SslOption;
import org.maachang.util.thread.LoopThread;

class NioSslServer
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(NioSslServer.class);
    private ServerSocket serverSocket = null;
    private ServerSocketChannel server = null;
    private Selector selector = null;
    private SslOption option = null;
    private NioSslReceiveServerArray recvServer = null;

    private NioSslServer() {
    }

    public NioSslServer(int recvLen, ServerSocketChannel channel, SslOption option, ReceiveLinkQueue executionQueue) throws Exception {
        if (channel == null || executionQueue == null || option == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.serverSocket = channel.socket();
        this.serverSocket.setReuseAddress(true);
        this.server = channel;
        this.selector = Selector.open();
        this.option = option;
        this.server.register(this.selector, 16);
        this.recvServer = new NioSslReceiveServerArray(executionQueue, recvLen);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        if (this.recvServer != null) {
            this.destroy();
        }
        this.recvServer = null;
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        SelectionKey key = itr.next();
                        SelectableChannel c = key.channel();
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
        this.server = null;
        this.option = null;
    }

    protected boolean execution() throws Exception {
        while (this.selector.select() > 0) {
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                SelectionKey key = itr.next();
                itr.remove();
                if (key == null) continue;
                if (!key.isValid()) {
                    NioTcpUtil.destroyKey(key);
                    continue;
                }
                NioSslUtil.toAcceptByPlural(key, this.recvServer, this.option);
            }
        }
        return true;
    }

    protected void toException(Throwable e) {
        LOG.warn((Object)"error", e);
    }
}

