/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioSslUtil;
import org.maachang.comet.net.nio.NioTcpUtil;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.comet.net.ssl.SslOption;
import org.maachang.util.thread.LoopThread;

class NioSingleSslServer
extends LoopThread {
    private ServerSocket serverSocket = null;
    private ServerSocketChannel server = null;
    private Selector selector = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;
    private SslOption option = null;

    private NioSingleSslServer() {
    }

    public NioSingleSslServer(ServerSocketChannel channel, SslOption option, ReceiveLinkQueue executionQueue) throws Exception {
        if (channel == null || executionQueue == null || option == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.serverSocket = channel.socket();
        this.serverSocket.setReuseAddress(true);
        this.server = channel;
        this.selector = Selector.open();
        this.option = option;
        this.server.register(this.selector, 16);
        this.isWriteQueue = new IsWriteQueue();
        this.executionQueue = executionQueue;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        NioTcpUtil.destroyKey(itr.next());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
        this.server = null;
        this.isWriteQueue = null;
        this.executionQueue = null;
        this.option = null;
    }

    protected boolean execution() throws Exception {
        NioTcpUtil.isWrite(this.isWriteQueue);
        while (this.selector.select() > 0) {
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                NioTcpUtil.isWrite(this.isWriteQueue);
                SelectionKey key = itr.next();
                itr.remove();
                if (key == null) continue;
                if (!key.isValid()) {
                    NioTcpUtil.destroyKey(key);
                    continue;
                }
                if (NioSslUtil.toAcceptBySingle(this.selector, key, this.isWriteQueue, this.option)) continue;
                NioSslUtil.isRead(this.selector, key, this.executionQueue);
                NioSslUtil.isWrite(this.selector, key, this.executionQueue);
            }
        }
        return true;
    }

    protected void toException(Throwable e) {
    }
}

