/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.WriteDataQueue;

class NioOutputStream
extends OutputStream {
    private static final int BUFFER_LENGTH = 1024;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private NioElement element = null;
    private WriteDataQueue writeBuffer = null;
    private ByteBuffer buffer = null;
    private int count = 0;
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioOutputStream create(NioElement element) throws Exception {
        if (element == null || !element.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            this.resetObject();
            this.element = element;
            this.writeBuffer = element.getWriteDataQueue();
            this.buffer = ByteBuffer.allocate(1024);
            this.buffer.clear();
            this.element.update();
        }
        return this;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetObject() {
        Object object = this.sync;
        synchronized (object) {
            if (this.writeBuffer != null && this.writeBuffer.isUse()) {
                this.flushTo();
                this.writeBuffer.append(EMPTY_BUFFER);
            }
            this.element = null;
            this.writeBuffer = null;
            this.buffer = null;
            this.count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            if (this.writeBuffer != null && this.writeBuffer.isUse()) {
                this.flushTo();
                this.writeBuffer.append(EMPTY_BUFFER);
            }
            this.element = null;
            this.writeBuffer = null;
            this.buffer = null;
            this.count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            if (this.writeBuffer == null || !this.writeBuffer.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            this.flushTo();
        }
    }

    private void flushTo() {
        if (this.count > 0) {
            this.buffer.flip();
            this.writeBuffer.append(this.buffer);
            this.buffer = ByteBuffer.allocate(1024);
            this.count = 0;
            this.element.restartWrite();
        }
        this.element.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            if (this.writeBuffer == null || !this.writeBuffer.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            if (this.count >= 1024) {
                this.flush();
            }
            this.buffer.put((byte)b);
            ++this.count;
        }
    }
}

