/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.maachang.comet.httpd.HttpdBinary;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.HttpdUtil;
import org.maachang.comet.net.HttpdRequestImpl;
import org.maachang.comet.net.RequestBuffer;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class ReadHttpdRequest {
    private static final int MAX_RETRY_COUNT = 24;
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String CHARSET = "UTF8";
    private static final byte[] ENTER = new byte[]{13, 10};
    private static final byte[] END_HEADER = new byte[]{13, 10, 13, 10};

    private ReadHttpdRequest() {
    }

    public static final void receiveHttpRequest(HttpdRequestImpl out, InputStream stream, RequestBuffer buf, int seqId) throws Exception {
        try {
            if (!ReadHttpdRequest.readHeader(out, stream, buf)) {
                throw new IOException("HTTP\u30d8\u30c3\u30c0\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            if ("POST".equals(out.getMethod())) {
                ReadHttpdRequest.readResponseByBody(out, stream, buf);
            }
        }
        finally {
            buf.reset();
        }
    }

    private static final boolean readHeader(HttpdRequestImpl out, InputStream stream, RequestBuffer buf) throws Exception {
        int endPoint = 0;
        int endHeaderLen = END_HEADER.length;
        buf.reset();
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                if (buf.getLength() <= 0) {
                    return false;
                }
                return ReadHttpdRequest.convertHttpdHeader(out, buf.getBinary(), buf.getLength());
            }
            buf.write(d &= 0xFF);
            if (d == (END_HEADER[endPoint] & 0xFF)) {
                if (++endPoint < endHeaderLen) continue;
                if (buf.getLength() <= 0) {
                    return false;
                }
                return ReadHttpdRequest.convertHttpdHeader(out, buf.getBinary(), buf.getLength());
            }
            endPoint = 0;
        }
    }

    private static final boolean readResponseByBody(HttpdRequest req, InputStream stream, RequestBuffer buf) throws Exception {
        buf.reset();
        if (req.getHeader().size(TRANSFER_ENCODING) != 0) {
            String s = req.getHeader().getHeader(TRANSFER_ENCODING, 0);
            if (!CHUNKED.equals(s)) {
                throw new IOException("\u4e0d\u6b63\u306a[Transfer-Encoding=" + s + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            ReadHttpdRequest.readBodyByChunked(buf, stream);
        } else if (req.getHeader().size(CONTENT_LENGTH) != 0) {
            String s = req.getHeader().getHeader(CONTENT_LENGTH, 0);
            if (s == null || s.length() <= 0) {
                throw new IOException("\u4e0d\u6b63\u306a[Content-Length]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            int contentLength = Integer.parseInt(s);
            if (contentLength <= -1) {
                throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577[" + contentLength + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (contentLength == 0) {
                return false;
            }
            ReadHttpdRequest.readBodyByLength(buf, contentLength, stream);
        } else {
            ReadHttpdRequest.readBodyByNoSetting(buf, stream);
        }
        if (buf.getLength() > 0) {
            ReadHttpdRequest.convertBody(req, buf.getBinary(buf.getLength()));
            return true;
        }
        return false;
    }

    private static final void readBodyByChunked(RequestBuffer buf, InputStream stream) throws Exception {
        int len = -1;
        int enterPos = 0;
        int pos = 0;
        int cnt = 0;
        int m1Cnt = 0;
        byte[] headBuf = new byte[32];
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                if (++m1Cnt > 24) {
                    throw new IOException("\u4e0d\u6b63\u306achunked\u7d42\u7aef\u3092\u691c\u51fa\u3057\u307e\u3057\u305f(" + len + ")");
                }
                Thread.sleep(1L);
                continue;
            }
            m1Cnt = 0;
            d &= 0xFF;
            ++cnt;
            if (len == -1) {
                if (d == (ENTER[enterPos] & 0xFF)) {
                    if (++enterPos < ENTER.length) continue;
                    if (pos > 0) {
                        String chLen = new String(headBuf, 0, pos, CHARSET);
                        len = ReadHttpdRequest.convertChunkedDataLength(chLen);
                        if (len == 0) {
                            int exitCnt = 0;
                            while (true) {
                                if (stream.available() <= 0) {
                                    continue;
                                }
                                stream.read();
                                if (++exitCnt >= ENTER.length) break;
                            }
                            return;
                        }
                        pos = 0;
                        enterPos = 0;
                        continue;
                    }
                    enterPos = 0;
                    continue;
                }
                if (enterPos >= 1) {
                    throw new IOException("\u4e0d\u6b63\u306achunked\u30c7\u30fc\u30bf\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                headBuf[pos] = (byte)d;
                ++pos;
                continue;
            }
            buf.write(d);
            if (len > ++pos) continue;
            len = -1;
            pos = 0;
            enterPos = 0;
        }
    }

    private static final void readBodyByLength(RequestBuffer buf, int contentLength, InputStream stream) throws Exception {
        int pnt = 0;
        int m1Cnt = 0;
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                if (++m1Cnt > 24) {
                    throw new IOException("ContentLength\u53d7\u4fe1\u4ee5\u524d\u306b\u901a\u4fe1\u304c\u5207\u65ad\u3055\u308c\u307e\u3057\u305f(" + contentLength + "/" + pnt + ")");
                }
                Thread.sleep(1L);
                continue;
            }
            m1Cnt = 0;
            buf.write(d);
            if (contentLength <= ++pnt) break;
        }
    }

    private static final void readBodyByNoSetting(RequestBuffer buf, InputStream stream) throws Exception {
        int pnt = 0;
        int m1Cnt = 0;
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                if (++m1Cnt > 24) {
                    return;
                }
                Thread.sleep(1L);
                continue;
            }
            m1Cnt = 0;
            buf.write(d);
            ++pnt;
        }
    }

    private static final int convertChunkedDataLength(String s) throws Exception {
        try {
            return Integer.parseInt(s, 16);
        }
        catch (Exception e) {
            if (s == null || s.length() <= 0) {
                throw new IOException("\u4e0d\u6b63\u306achunked\u30d8\u30c3\u30c0\u6570\u5024\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            throw new IOException("\u4e0d\u6b63\u306achunked\u30d8\u30c3\u30c0\u6570\u5024[" + s + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
        }
    }

    private static int binaryIndexOf(byte[] binary, String data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length() <= 0) {
            return -1;
        }
        return ReadHttpdRequest.binaryIndexOf(binary, data.getBytes(CHARSET), off, len);
    }

    private static int binaryIndexOf(byte[] binary, byte[] data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length <= 0) {
            return -1;
        }
        int dataLen = data.length;
        if (len <= 0 || len >= binary.length) {
            len = binary.length;
        }
        int ret = -1;
        int i = off;
        while (i < len) {
            if (binary[i] == data[0] && i + dataLen <= len) {
                ret = i;
                int j = 1;
                while (j < dataLen) {
                    if (binary[i + j] != data[j]) {
                        ret = -1;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) {
                    return ret;
                }
            }
            ++i;
        }
        return -1;
    }

    private static final boolean convertHttpdHeader(HttpdRequestImpl out, byte[] binary, int endPos) throws Exception {
        out.create();
        int p = 0;
        int b = 0;
        int line = 0;
        int enterLen = ENTER.length;
        while (true) {
            if ((p = ReadHttpdRequest.binaryIndexOf(binary, ENTER, b, endPos)) == -1) {
                if (b >= endPos) break;
                p = endPos;
            }
            String one = new String(binary, b, p - b, CHARSET);
            b = p + enterLen;
            if (line == 0) {
                ReadHttpdRequest.convertHttpExecutionAndVersion(out, one);
                if (out.getHttpVersion().endsWith("0.9")) {
                    ReadHttpdRequest.convertAnalysisQuery(out);
                    return true;
                }
            } else {
                ReadHttpdRequest.convertHttpHeader(out, one);
            }
            if (p >= endPos) break;
            ++line;
        }
        ReadHttpdRequest.convertAnalysisQuery(out);
        return true;
    }

    private static final void convertHttpExecutionAndVersion(HttpdRequest out, String oneLine) {
        int pos1 = oneLine.indexOf(" ");
        int pos2 = oneLine.indexOf(" ", pos1 + 1);
        String exec = oneLine.substring(0, pos1);
        String url = oneLine.substring(pos1 + 1, pos2);
        String version = oneLine.substring(pos2 + 1, oneLine.length());
        out.setMethod(exec.trim());
        out.setUrlPath(url.trim());
        out.setHttpVersion(version.trim());
    }

    private static final void convertHttpHeader(HttpdRequest out, String oneLine) {
        int p = oneLine.indexOf(":");
        if (p == -1) {
            return;
        }
        String key = oneLine.substring(0, p).trim();
        if ((oneLine = oneLine.substring(++p + 1, oneLine.length())) == null || (oneLine = oneLine.trim()).length() <= 0) {
            out.getHeader().addHeader(key, null);
        } else if (key.indexOf("User-Agent") != -1 || key.indexOf("Modified") != -1 || key.indexOf("Date") != -1) {
            out.getHeader().addHeader(key, oneLine);
        } else if (oneLine.indexOf(",") != -1) {
            ArrayList lst = StringUtil.cutString((String)oneLine, (String)",");
            int len = lst.size();
            HttpdHeaders header = out.getHeader();
            int i = 0;
            while (i < len) {
                String o;
                if (i == 0) {
                    o = ((String)lst.get(i)).trim();
                    if (o.length() > 0) {
                        int sp = o.indexOf(" ");
                        if (sp != -1) {
                            boolean flg = false;
                            int j = 0;
                            while (j < sp) {
                                char c = o.charAt(j);
                                if (c == '\"' || c == '\'') {
                                    flg = true;
                                    break;
                                }
                                ++j;
                            }
                            if (flg) {
                                header.addHeader(key, o);
                            } else {
                                header.addHeader(key, o.substring(0, sp).trim());
                                header.addHeader(key, o.substring(sp + 1).trim());
                            }
                        } else {
                            header.addHeader(key, o);
                        }
                    }
                } else {
                    o = ((String)lst.get(i)).trim();
                    if (o.length() > 0) {
                        header.addHeader(key, o);
                    }
                }
                ++i;
            }
        } else if ((oneLine = oneLine.trim()).length() > 0) {
            out.getHeader().addHeader(key, oneLine);
        }
    }

    public static final void convertAnalysisQuery(HttpdRequest out) {
        String query = HttpdUtil.getQueryValue(out.getUrlPath());
        if (query != null && (query = query.trim()).length() > 0) {
            out.setUrlPath(HttpdUtil.getReadName(out.getUrlPath()));
            HttpdUtil.convertQueryByParams(out.getQuery(), query, CHARSET);
        } else {
            String url = out.getUrlPath().trim();
            if (url.endsWith("?")) {
                out.setUrlPath(url.substring(0, url.length() - 1));
            }
        }
    }

    private static final void convertAnalysisBody(HttpdRequest out, String body) {
        if (body != null && (body = body.trim()).length() > 0) {
            HttpdUtil.convertQueryByParams(out.getQuery(), body, CHARSET);
        }
    }

    public static final void convertBody(HttpdRequest out, byte[] binary) throws Exception {
        block27: {
            int p = 0;
            int b = 0;
            int enterLen = ENTER.length;
            int len = out.getHeader().size("Content-Type");
            String multiPartForm = null;
            String dataType = null;
            int i = 0;
            while (i < len) {
                String contentType = out.getHeader().getHeader("Content-Type", i);
                if (multiPartForm == null) {
                    int boundary = -1;
                    boundary = contentType.indexOf("multipart/form-data");
                    if (boundary != -1 && (boundary = contentType.indexOf("boundary=", boundary)) != -1) {
                        multiPartForm = contentType.substring(boundary + "boundary=".length(), contentType.length());
                    }
                }
                if (dataType == null || !contentType.startsWith(FORM_CONTENT_TYPE)) {
                    dataType = contentType;
                }
                ++i;
            }
            if (dataType == null) {
                dataType = FORM_CONTENT_TYPE;
            }
            if (multiPartForm != null) {
                out.setBody(null);
                String target = "--" + multiPartForm;
                String end = String.valueOf(target) + "--";
                String keyName = null;
                String fileName = null;
                String mimeType = null;
                boolean dataFlag = false;
                boolean keyFlag = false;
                int filenameLen = "; filename=\"".length();
                int nameLen = "; name=\"".length();
                while (true) {
                    String one;
                    if (!dataFlag) {
                        int namePnt;
                        int filePnt;
                        p = ReadHttpdRequest.binaryIndexOf(binary, ENTER, b, binary.length);
                        if (p == -1) break block27;
                        if (p == b) {
                            if (keyFlag) {
                                dataFlag = true;
                            }
                            b += enterLen;
                            continue;
                        }
                        one = new String(binary, b, p - b, CHARSET);
                        b = p + enterLen;
                        if (!keyFlag) {
                            if (one.equals(target)) {
                                keyFlag = true;
                                continue;
                            }
                            if (!one.equals(end)) {
                                throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                            }
                            break block27;
                        }
                        if (one.startsWith("Content-Disposition:") && (filePnt = one.indexOf("; filename=\"")) != -1) {
                            String fullPath = one.substring(filePnt += filenameLen, one.indexOf("\"", filePnt)).trim();
                            fileName = FileUtil.getFileName((String)fullPath).trim();
                        }
                        if ((namePnt = one.indexOf("; name=\"")) != -1) {
                            keyName = one.substring(namePnt += nameLen, one.indexOf("\"", namePnt)).trim();
                            continue;
                        }
                        if (one.startsWith("Content-Type:")) {
                            mimeType = one.substring("Content-Type:".length(), one.length()).trim();
                            continue;
                        }
                        throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f:[" + one + "]");
                    }
                    if (fileName != null) {
                        p = ReadHttpdRequest.binaryIndexOf(binary, target, b, binary.length);
                        if (p == -1) {
                            throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                        }
                        if (fileName == null || (fileName = fileName.trim()).length() <= 0) {
                            b = p;
                        } else {
                            len = p - (b + enterLen);
                            byte[] uploadBinary = new byte[len];
                            System.arraycopy(binary, b, uploadBinary, 0, len);
                            b = p;
                            HttpdBinary bin = new HttpdBinary(fileName, mimeType, uploadBinary);
                            out.getQuery().addParam(keyName, bin);
                        }
                    } else {
                        p = ReadHttpdRequest.binaryIndexOf(binary, target, b, binary.length);
                        if (p == -1) {
                            throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                        }
                        one = new String(binary, b, p - (b + enterLen), CHARSET);
                        b = p;
                        out.getQuery().addParam(keyName, one);
                    }
                    keyName = null;
                    fileName = null;
                    mimeType = null;
                    dataFlag = false;
                    keyFlag = false;
                }
            }
            if (dataType != null && dataType.startsWith(FORM_CONTENT_TYPE)) {
                String charset = ReadHttpdRequest.getCharset(dataType);
                out.setBody(binary);
                boolean end = false;
                StringBuilder buf = new StringBuilder();
                while (!end) {
                    p = ReadHttpdRequest.binaryIndexOf(binary, ENTER, b, binary.length);
                    if (p <= -1) {
                        p = binary.length;
                        end = true;
                    }
                    if (p == b) {
                        b += enterLen;
                        continue;
                    }
                    String one = new String(binary, b, p - b, charset);
                    one = StringUtil.changeString((String)one, (String)"\r", (String)"");
                    one = StringUtil.changeString((String)one, (String)"\n", (String)"");
                    b = p + enterLen;
                    if (one.length() <= 0) break;
                    buf.append(one);
                }
                String bodys = buf.toString();
                buf = null;
                ReadHttpdRequest.convertAnalysisBody(out, bodys);
                bodys = null;
            } else {
                out.setBody(binary);
            }
        }
    }

    private static final String getCharset(String contentType) {
        int p = contentType.indexOf("charset=");
        if (p <= -1) {
            return CHARSET;
        }
        return contentType.substring(p + "charset=".length());
    }
}

