/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import org.maachang.comet.net.HttpServer;

class NetServerImpl
implements HttpServer {
    private static final int DEFAULT_PORT = 3333;
    protected static final int MIN_LENGTH = 1;
    protected static final int MAX_LENGTH = 50000;
    private ServerSocket serverSocket = null;

    private NetServerImpl() {
    }

    public NetServerImpl(int port, int backlog) throws Exception {
        this(null, port, backlog);
    }

    public NetServerImpl(InetAddress addr, int port, int backlog) throws Exception {
        if (backlog <= 1) {
            backlog = 1;
        } else if (backlog > 50000) {
            backlog = 50000;
        }
        if (port <= 0 || port > 65535) {
            port = 3333;
        }
        ServerSocket server = ServerSocketChannel.open().socket();
        server.getChannel().configureBlocking(false);
        server.setReuseAddress(true);
        if (addr == null) {
            server.bind(new InetSocketAddress(port), backlog);
        } else {
            server.bind(new InetSocketAddress(addr, port), backlog);
        }
        this.serverSocket = server;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
    }

    public ServerSocketChannel channel() {
        if (this.isClosed()) {
            return null;
        }
        return this.serverSocket.getChannel();
    }

    public Object option() {
        return null;
    }

    public boolean isClosed() {
        boolean ret = false;
        try {
            if (this.serverSocket == null || !this.serverSocket.isBound() || this.serverSocket.isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

