/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.HttpdCookie;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.comet.net.HttpdHeadersImpl;
import org.maachang.comet.net.HttpdParamsImpl;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.manager.GlobalManager;

public class HttpdRequestImpl
implements HttpdRequest {
    private String method = null;
    private String httpVersion = null;
    private String urlPath = null;
    private String remoteAddress = null;
    private int remotePort = -1;
    private final HttpdParamsImpl query = new HttpdParamsImpl();
    private final HttpdHeadersImpl header = new HttpdHeadersImpl();
    private HttpdSession session = null;
    private byte[] httpBody = null;
    private ConnectionInfo conn = null;
    private boolean gzipFlag = false;
    private boolean cookieFlag = false;
    private boolean sslFlag = false;
    private static final String[] SESSION_LIST = new String[]{".ms", ".mhtml", ".js", ".html", ".htm"};

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create() {
        this.clear();
        this.sslFlag = false;
    }

    public void clear() {
        this.query.clear();
        this.header.clear();
        this.method = null;
        this.httpVersion = null;
        this.urlPath = null;
        this.remoteAddress = null;
        this.remotePort = -1;
        this.session = null;
        this.httpBody = null;
        this.conn = null;
        this.gzipFlag = false;
        this.cookieFlag = false;
        this.sslFlag = false;
    }

    public HttpdRequest copy() throws Exception {
        if (this.conn == null) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u69cb\u6210\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ConnectionInfo c = this.conn.copy();
        HttpdRequestImpl ret = new HttpdRequestImpl();
        this.query.copy(ret.query);
        this.header.copy(ret.header);
        ret.method = this.method;
        ret.httpVersion = this.httpVersion;
        ret.urlPath = this.urlPath;
        ret.remoteAddress = this.remoteAddress;
        ret.remotePort = this.remotePort;
        ret.session = this.session;
        ret.httpBody = this.httpBody;
        ret.conn = c;
        ret.gzipFlag = this.gzipFlag;
        ret.cookieFlag = this.cookieFlag;
        ret.sslFlag = this.sslFlag;
        return ret;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getVersion() {
        return this.httpVersion.substring("HTTP/".length());
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setRemote(String addr, int port) {
        this.remoteAddress = addr;
        this.remotePort = port;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public HttpdParams getQuery() {
        return this.query;
    }

    public HttpdHeaders getHeader() {
        return this.header;
    }

    public HttpdSession getSession() throws Exception {
        if (this.session == null) {
            HttpdSessionManager sessionManager = (HttpdSessionManager)GlobalManager.getValue((String)"SESSION_MANAGER");
            String id = null;
            String cookie = HttpdCookie.getCookie(this);
            if (cookie != null) {
                HashMap<String, String> ana = HttpdCookie.analysisCookie(cookie);
                id = ana.get("maachang-session");
                if (id != null && id.length() == 48) {
                    this.session = sessionManager.getSession(id);
                }
                this.cookieFlag = true;
            }
            if (this.session == null) {
                if (HttpdRequestImpl.isSessionId(this.urlPath)) {
                    id = this.query.getParam("_maachang-session");
                    this.session = id != null && id.length() == 48 && sessionManager.getSession(id) != null ? sessionManager.getSession(id) : sessionManager.getNewSession();
                    this.query.setParam("_maachang-session", this.session.getSessionId());
                }
                this.cookieFlag = false;
            }
        }
        return this.session;
    }

    public InputStream getBody() {
        if (this.httpBody == null) {
            return null;
        }
        return new ByteArrayInputStream(this.httpBody);
    }

    public byte[] getBodyByBinary() {
        if (this.httpBody == null) {
            return null;
        }
        return this.httpBody;
    }

    public void setBody(byte[] body) {
        this.httpBody = (byte[])(body == null || body.length <= 0 ? null : body);
    }

    public void setConnectionInfo(ConnectionInfo conn) {
        this.sslFlag = conn.getElement().getSslElement() != null;
        this.conn = conn;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.conn;
    }

    public void setKeepAliveTimeout(int timeout) {
        if ((long)timeout > 0L) {
            this.conn.setTimeout(timeout);
        }
    }

    public long getKeepAliveTimeout() {
        if (this.conn == null) {
            return -1L;
        }
        return this.conn.getTimeout();
    }

    public int getKeepAliveCount() {
        if (this.conn == null) {
            return -1;
        }
        return this.conn.getCount();
    }

    public void setGzip(boolean flag) {
        this.gzipFlag = flag;
    }

    public boolean isGzip() {
        return this.gzipFlag;
    }

    public boolean isCookie() {
        return this.cookieFlag;
    }

    public boolean isSsl() {
        return this.sslFlag;
    }

    public boolean isUse() {
        return this.conn != null && this.conn.isUse();
    }

    public String toIpPort() {
        return this.conn.getInetAddress().getHostAddress() + "/" + this.conn.getPort();
    }

    public static final boolean isSessionId(String path) {
        int x = path.lastIndexOf("/");
        if (x >= 0) {
            path = path.substring(x);
        }
        if (path.lastIndexOf(".") <= -1) {
            return true;
        }
        int len = SESSION_LIST.length;
        path = path.trim().toLowerCase();
        int i = 0;
        while (i < len) {
            if (path.endsWith(SESSION_LIST[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

