/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.maachang.comet.httpd.HttpdBinary;
import org.maachang.comet.httpd.HttpdParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpdParamsImpl
implements HttpdParams {
    private Map<String, Object> params = null;

    protected void finalize() throws Exception {
        this.params = null;
    }

    public void clear() {
        this.params = null;
    }

    public void copy(HttpdParamsImpl obj) {
        if (obj == null) {
            return;
        }
        obj.params = this.params;
    }

    @Override
    public void add(HttpdParams param) {
        if (param == null || param.size() <= 0) {
            return;
        }
        Iterator it = param.iterator();
        if (it != null) {
            while (it.hasNext()) {
                String key = (String)it.next();
                int len = param.size(key);
                int i = 0;
                while (i < len) {
                    this.addParam(key, param.getParam(key, i));
                    ++i;
                }
            }
        }
    }

    @Override
    public void addParam(String key, Object value) {
        this.pushParam(false, key, value);
    }

    @Override
    public void setParam(String key, Object value) {
        this.pushParam(true, key, value);
    }

    private void pushParam(boolean mode, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        } else if (!(value instanceof String) && !(value instanceof HttpdBinary)) {
            return;
        }
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        if (mode) {
            this.params.put(key, value);
        } else if (!this.params.containsKey(key)) {
            this.params.put(key, value);
        } else {
            ArrayList<Object> lst = null;
            Object v = this.params.get(key);
            if (v instanceof List) {
                lst = (ArrayList<Object>)v;
            } else {
                lst = new ArrayList<Object>();
                lst.add(v);
                this.params.put(key, lst);
            }
            lst.add(value);
        }
    }

    @Override
    public void removeParam(String key) {
        if (key == null || this.params == null) {
            return;
        }
        this.params.remove(key);
    }

    @Override
    public void removeParam(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return;
        }
        if (len == 1) {
            this.params.remove(key);
        } else {
            ArrayList v = (ArrayList)this.params.get(key);
            v.remove(no);
        }
    }

    @Override
    public String getParam(String key) {
        return this.getParam(key, 0);
    }

    @Override
    public String getParam(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return null;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return null;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            v = ((ArrayList)v).get(no);
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }

    @Override
    public HttpdBinary getParamByBinary(String key) {
        return this.getParamByBinary(key, 0);
    }

    @Override
    public HttpdBinary getParamByBinary(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return null;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return null;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            v = ((ArrayList)v).get(no);
        }
        if (v instanceof String) {
            HttpdBinary b = null;
            try {
                b = new HttpdBinary(key, "text/plain", ((String)v).getBytes("UTF8"));
            }
            catch (Exception e) {
                b = null;
            }
            return b;
        }
        return (HttpdBinary)v;
    }

    @Override
    public boolean getParamType(String key) {
        return this.getParamType(key, 0);
    }

    @Override
    public boolean getParamType(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return false;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return false;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            v = ((ArrayList)v).get(no);
        }
        return !(v instanceof String);
    }

    @Override
    public int size() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public int size(String key) {
        if (key == null || this.params == null) {
            return 0;
        }
        return this.getKeyByLength(key);
    }

    @Override
    public String[] getKeys() {
        if (this.params == null || this.params.size() <= 0) {
            return null;
        }
        Object[] keys = this.params.keySet().toArray();
        if (keys != null) {
            int len = keys.length;
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    @Override
    public Iterator iterator() {
        if (this.params != null && this.params.size() > 0) {
            return this.params.keySet().iterator();
        }
        return null;
    }

    @Override
    public boolean isKey(String key) {
        if (this.params == null) {
            return false;
        }
        return this.params.containsKey(key);
    }

    @Override
    public Map<String, Object> getPrivateMap() {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        return this.params;
    }

    public String toString() {
        String[] keys = this.getKeys();
        if (keys != null) {
            StringBuilder buf = new StringBuilder();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                Object v;
                if (i != 0) {
                    buf.append(",");
                }
                if ((v = this.params.get(keys[i])) instanceof List) {
                    List lst = (List)v;
                    if (lst != null) {
                        int lenJ = lst.size();
                        int j = 0;
                        while (j < lenJ) {
                            if (j != 0) {
                                buf.append(",");
                            }
                            Object objs = lst.get(j);
                            buf.append(" [").append(keys[i]).append(":");
                            if (objs instanceof String) {
                                buf.append(objs).append("]");
                            } else if (objs instanceof HttpdBinary) {
                                buf.append(" orginal/").append(((HttpdBinary)objs).getOriginalName()).append(" length/").append(((HttpdBinary)objs).getLength()).append("]");
                            }
                            ++j;
                        }
                    }
                } else {
                    buf.append(" [").append(keys[i]).append(":");
                    if (v instanceof String) {
                        buf.append(v).append("]");
                    } else if (v instanceof HttpdBinary) {
                        buf.append(" orginal/").append(((HttpdBinary)v).getOriginalName()).append(" length/").append(((HttpdBinary)v).getLength()).append("]");
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }

    private int getKeyByLength(String key) {
        if (key == null || key.length() <= 0) {
            return 0;
        }
        if (!this.params.containsKey(key)) {
            return 0;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            return ((ArrayList)v).size();
        }
        return 1;
    }
}

