/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.conf.ConvIniParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpdHeadersImpl
implements HttpdHeaders {
    private Map<String, List<Object>> headers = null;

    protected void finalize() throws Exception {
        this.headers = null;
    }

    public void clear() {
        this.headers = null;
    }

    public void copy(HttpdHeadersImpl obj) {
        if (obj == null) {
            return;
        }
        obj.headers = this.headers;
    }

    @Override
    public void add(HttpdHeaders header) {
        if (header == null || header.size() <= 0) {
            return;
        }
        Iterator it = header.iterator();
        if (it != null) {
            while (it.hasNext()) {
                String key = (String)it.next();
                int len = header.size(key);
                int i = 0;
                while (i < len) {
                    this.addHeader(key, header.getHeader(key, i));
                    ++i;
                }
            }
        }
    }

    @Override
    public void addHeader(String key, String value) {
        this.pushHeader(false, key, value);
    }

    @Override
    public void setHeader(String key, String value) {
        this.pushHeader(true, key, value);
    }

    private void pushHeader(boolean mode, String key, String value) {
        String val = null;
        if (key == null) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, List<Object>>();
        }
        val = value;
        if (mode) {
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(val);
            this.headers.put(key, lst);
        } else {
            List<Object> lst = this.headers.get(key);
            if (lst == null) {
                lst = new ArrayList<Object>();
                this.headers.put(key, lst);
            }
            lst.add(val);
        }
    }

    @Override
    public void removeHeader(String key) {
        if (key == null || this.headers == null) {
            return;
        }
        this.headers.remove(key);
    }

    @Override
    public void removeHeader(String key, int no) {
        if (key == null || this.headers == null || no < 0) {
            return;
        }
        List<Object> lst = this.headers.get(key);
        if (lst == null || lst.size() <= no) {
            return;
        }
        lst.remove(no);
        if (lst.size() <= 0) {
            this.headers.remove(key);
        }
    }

    @Override
    public String getHeader(String key) {
        return this.getHeader(key, 0);
    }

    @Override
    public String getHeader(String key, int no) {
        if (key == null || this.headers == null || no < 0) {
            return null;
        }
        List<Object> lst = this.headers.get(key);
        if (lst == null || lst.size() <= no) {
            return null;
        }
        Object ret = lst.get(no);
        if (ret == null) {
            return null;
        }
        return (String)ret;
    }

    @Override
    public HashMap<String, String> getHeaders(String key) {
        if (key == null || this.headers == null) {
            return null;
        }
        List<Object> lst = this.headers.get(key);
        if (lst == null || lst.size() <= 0) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        int len = lst.size();
        int i = 0;
        while (i < len) {
            Object val = lst.get(i);
            if (val != null) {
                String str = (String)val;
                int p = str.indexOf("=");
                if (p != -1) {
                    String k = str.substring(0, p);
                    String v = str.substring(p + 1, str.length());
                    if ((k = k.trim()).length() > 0 && (v = v.trim()).length() > 0) {
                        if (v.startsWith("\"") || v.startsWith("'")) {
                            v = v.substring(1, v.length() - 1);
                        }
                        ret.put(k, v);
                    }
                } else {
                    ret.put(str.trim(), "");
                }
            }
            ++i;
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    @Override
    public int size() {
        return this.headers == null ? 0 : this.headers.size();
    }

    @Override
    public int size(String key) {
        if (key == null || this.headers == null) {
            return 0;
        }
        List<Object> lst = this.headers.get(key);
        if (lst == null) {
            return 0;
        }
        return lst.size();
    }

    @Override
    public String[] getKeys() {
        if (this.headers == null || this.headers.size() <= 0) {
            return null;
        }
        Object[] keys = this.headers.keySet().toArray();
        if (keys != null) {
            int len = keys.length;
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    @Override
    public Iterator iterator() {
        if (this.headers != null && this.headers.size() > 0) {
            return this.headers.keySet().iterator();
        }
        return null;
    }

    @Override
    public boolean isKey(String key) {
        if (this.headers == null) {
            return false;
        }
        return this.headers.get(key) != null;
    }

    @Override
    public long getKeepAlive() {
        String s = this.getHeader("Keep-Alive");
        if (s != null) {
            return ConvIniParam.getLong((String)s);
        }
        return -1L;
    }

    @Override
    public boolean isKeepAlive() {
        return this.getHeader("Connection") != null && "keep-alive".equals(this.getHeader("Connection").toLowerCase());
    }

    public String toString() {
        String[] keys = this.getKeys();
        if (keys != null) {
            StringBuilder buf = new StringBuilder();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                List<Object> lst;
                if (i != 0) {
                    buf.append(",");
                }
                if ((lst = this.headers.get(keys[i])) != null) {
                    int lenJ = lst.size();
                    int j = 0;
                    while (j < lenJ) {
                        if (j != 0) {
                            buf.append(",");
                        }
                        Object objs = lst.get(j);
                        buf.append(" [").append(keys[i]).append(":");
                        if (objs == null) {
                            buf.append("]");
                        } else {
                            buf.append(objs).append("]");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

