/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.PageCache;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScriptAnalysis;
import org.maachang.comet.httpd.engine.script.taglib.AnalysisTagLib;
import org.maachang.util.FileUtil;

public class MhtmlScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected long updateTime = -1L;
    private SrcScript srcScript = null;
    protected ExecutionScriptImpl executionScript = null;
    private int packageId = -1;
    private long cacheTime = -1L;

    private MhtmlScript() {
    }

    public MhtmlScript(String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "mhtml\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".mhtml")) {
            path = String.valueOf(path) + ".mhtml";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + "application/" + (path.startsWith("/") ? path.substring(1, path.length()) : path)))) {
            throw new HttpdStateException(500, "\u5bfe\u8c61mhtml\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path;
        this.fileName = fileName;
    }

    protected void clear() {
        this.updateTime = -1L;
        this.srcScript = null;
        this.executionScript = null;
        this.cacheTime = -1L;
    }

    public synchronized ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            this.clear();
            throw new HttpdStateException(500, "\u5bfe\u8c61mhtml\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript == null || this.updateTime != FileUtil.getLastTime((String)this.fileName) || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getScriptName() {
        return this.fileName;
    }

    public int getScriptType() {
        return 10;
    }

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    public synchronized boolean isPageCache() {
        return this.cacheTime > 0L;
    }

    public synchronized long getPageCacheTime() {
        return this.cacheTime;
    }

    protected void readScript() throws Exception {
        StringBuilder buf;
        String script = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
        if (script == null) {
            this.clear();
            return;
        }
        String[] sc = new String[]{script};
        long tm = PageCache.getInstance().analysisCacheMode(sc);
        if (tm > 0L) {
            script = sc[0];
            sc = null;
            script = ReadScriptPlus.directInclude("./", script);
            script = AnalysisTagLib.analysis(script);
            script = TemplateScriptAnalysis.analysis(script);
            String mhtmlName = this.path.substring(0, this.path.length() - ".mhtml".length());
            StringBuilder buf2 = new StringBuilder();
            buf2.append("var __$page_cache_flag = true ;\n").append("if( isNull( _$global.").append("_$script$controllerName").append(" ) == false && ").append(" _$global.").append("_$script$controllerName").append(" != \"").append(mhtmlName).append("\"").append(" ) { __$page_cache_flag = false ; }\n");
            buf2.append("if( __$page_cache_flag ) { \n").append("var ").append("$pageCache").append(" = new StrBuf() ;\r\n").append("httpPrint = function( str ) { if( useString( str ) ) { ").append("$pageCache").append(".ad( str ); } } ;\n").append(" } \n");
            buf2.append(script).append("\n");
            buf2.append("if( __$page_cache_flag ) { \n").append("var _$_$_out_$_$_ = ").append("$pageCache").append(".ts() ;\n").append("$pageCache").append(".clear() ;\n").append("$pageCache").append(" = null ;\n").append("org.maachang.comet.httpd.engine.script.scripts.PageCache.getInstance().set( \"").append(this.path).append("\",").append(tm).append(",_$_$_out_$_$_ ) ;\n").append("httpPrintln( _$_$_out_$_$_ ) ;\n").append(" } \n");
            script = buf2.toString();
            buf2 = null;
            this.cacheTime = tm;
        } else {
            sc = null;
            script = ReadScriptPlus.directInclude("./", script);
            script = AnalysisTagLib.analysis(script);
            script = TemplateScriptAnalysis.analysis(script);
            buf = new StringBuilder();
            buf.append("var ___$_$_$rs$buf$_$ = new StrBuf() ;\n").append("httpPrint = function( str ) { if( useString( str ) ) { ").append("___$_$_$rs$buf$_$.ad( str ); } } ;\n").append(script).append("\n").append("httpPrintln( ___$_$_$rs$buf$_$.ts() ) ;\n ___$_$_$rs$buf$_$.clear();\n___$_$_$rs$buf$_$=null;\n");
            script = buf.toString();
            buf = null;
            this.cacheTime = -1L;
        }
        buf = new StringBuilder();
        this.packageId = JsDef.pushDefaultPackage(buf);
        ReadScriptPlus.addMHTML(buf, script, this.path);
        script = buf.toString();
        buf = null;
        script = ReadScriptPlus.convert(false, script);
        this.srcScript = new SrcScript(script);
        this.executionScript = new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script);
        script = null;
        this.updateTime = FileUtil.getLastTime((String)this.fileName);
    }
}

