/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.js;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.oro.text.perl.Perl5Util;
import org.maachang.util.StringUtil;
import org.maachang.util.image.ImageConvertor;
import org.maachang.util.image.ImageInfo;

public class BaseValidate {
    public static final boolean isString(int type, String src) {
        if (src == null || (src = src.trim()).length() <= 0) {
            src = "";
        }
        return !StringUtil.checkType((int)type, (String)src);
    }

    public static final boolean isString(Integer min, Integer max, String src) {
        if (src == null || (src = src.trim()).length() <= 0) {
            src = "";
        }
        return !BaseValidate.minLength(src, min) || !BaseValidate.maxLength(src, max);
    }

    public static final boolean isDate(String format, String src) {
        if (src == null || (src = src.trim()).length() <= 0 || format == null || (format = format.trim()).length() <= 0) {
            return true;
        }
        boolean ret = false;
        try {
            new SimpleDateFormat(format, Locale.JAPAN).parse(src);
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }

    public static final boolean isMatch(String match, String src) {
        return BaseValidate.isPerl5Util_Match(match, src);
    }

    public static final boolean isZip(String src) {
        return BaseValidate.isPerl5Util_Match("/^\\d{3}\\-\\d{4}$/", src);
    }

    public static final boolean isIsbn(String src) {
        return BaseValidate.isPerl5Util_Match("/ISBN\\x20(?=.{13}$)\\d{1,5}([- ])\\d{1,7}\\1\\d{1,6}\\1(\\d|X)$/", src);
    }

    public static final boolean isIpAddress(String src) {
        return BaseValidate.isPerl5Util_Match("/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$/", src);
    }

    public static final boolean isUrl(String src) {
        return BaseValidate.isPerl5Util_Match("/^(((ht|f)tp(s?))\\:\\/\\/)([0-9a-zA-Z\\-]+\\.)+[a-zA-Z]{2,6}(\\:[0-9]+)?(\\/\\S*)?$/", src);
    }

    public static final boolean isEmail(String src) {
        return BaseValidate.isPerl5Util_Match("/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*(\\.([a-z]){2,4})$/", src);
    }

    public static final boolean isImageWidthHeight(byte[] binary, int width, int height) {
        if (binary == null || binary.length <= 0 || width <= 0 || width > 65535 || height <= 0 || height > 65535) {
            return true;
        }
        try {
            ImageInfo img = ImageConvertor.loadImage((InputStream)new ByteArrayInputStream(binary));
            if (img.getWidth() > width || img.getHeight() > height) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private static boolean minLength(String chkString, Integer min) {
        if (min == null) {
            return true;
        }
        int len = -1;
        try {
            len = min;
        }
        catch (Exception e) {
            len = -1;
        }
        if (len == -1) {
            return true;
        }
        return chkString.length() > len;
    }

    private static boolean maxLength(String chkString, Integer max) {
        if (max == null) {
            return true;
        }
        int len = -1;
        try {
            len = max;
        }
        catch (Exception e) {
            len = -1;
        }
        if (len == -1) {
            return true;
        }
        return chkString.length() < len;
    }

    private static boolean isPerl5Util_Match(String match, String src) {
        try {
            if (match == null || match.length() <= 0) {
                return true;
            }
            if (src == null || (src = src.trim()).length() <= 0) {
                return true;
            }
            boolean ret = new Perl5Util().match(match, src);
            return !ret;
        }
        catch (Exception e) {
            return true;
        }
    }
}

