/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.image;

import java.io.IOException;
import org.maachang.comet.httpd.engine.script.image.ImageData;
import org.maachang.comet.httpd.engine.script.image.ImageOp;
import org.maachang.dbm.MDbm;

class ImageOpImpl
implements ImageOp {
    private static final String KEY_HEAD = "org.maachang.comet.httpd.engine.script.image.ImageOpImpl.";
    private static final int SEQ_NO = 0;
    private MDbm mdbm = null;

    private ImageOpImpl() {
    }

    protected ImageOpImpl(MDbm mdbm) {
        this.mdbm = mdbm;
    }

    public long add(int type, byte[] image) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (type < 0 || type >= ImageData.IMAGE_MIME.length || image == null || image.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        long id = this.mdbm.sequenceId(0);
        byte[] key = this.imageId(id);
        byte[] value = ImageData.save(type, System.currentTimeMillis(), image);
        this.mdbm.put(key, value);
        return id;
    }

    public void set(int type, byte[] image, long id) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (id < 0L || type < 0 || type >= ImageData.IMAGE_MIME.length || image == null || image.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] key = this.imageId(id);
        byte[] value = ImageData.save(type, System.currentTimeMillis(), image);
        this.mdbm.put(key, value);
    }

    public ImageData get(long id) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (id < 0L) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] bin = this.mdbm.get(this.imageId(id));
        if (bin != null) {
            return ImageData.load(bin);
        }
        return null;
    }

    public synchronized void remove(long id) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (id < 0L) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.mdbm.remove(this.imageId(id));
    }

    public MDbm getMDbm() {
        return this.mdbm;
    }

    public boolean isImageId(long id) {
        if (!this.check() || id < 0L) {
            return false;
        }
        boolean ret = false;
        try {
            ret = this.mdbm.containsKey(this.imageId(id));
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public String getDirectory() {
        if (this.check()) {
            return this.mdbm.getDirectory();
        }
        return null;
    }

    public boolean isWrite() {
        boolean ret = false;
        try {
            if (this.mdbm != null && this.mdbm.isUse()) {
                this.mdbm.check();
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private boolean check() {
        return this.mdbm != null && this.mdbm.isUse();
    }

    private byte[] imageId(long id) throws Exception {
        if (id < 0L) {
            return null;
        }
        byte[] ret = (KEY_HEAD + id).getBytes("UTF8");
        return ret;
    }
}

