/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.image;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import org.maachang.comet.httpd.engine.script.image.ImageOp;
import org.maachang.comet.httpd.engine.script.image.ImageOpImpl;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.client.MDbmDriverManager;
import org.maachang.util.image.BaseImageConvertor;
import org.maachang.util.image.ImageConvertor;
import org.maachang.util.image.ImageInfo;

public class ImageManager {
    private ImageManager() {
    }

    public static final ImageOp getImageOp(MDbm mdbm) throws Exception {
        return new ImageOpImpl(mdbm);
    }

    public static final ImageOp getImageOp(boolean mode) throws Exception {
        return new ImageOpImpl(MDbmManager.getInstance().getMDbm(mode));
    }

    public static final ImageOp getImageOp(InetAddress addr, int port) {
        ImageOpImpl ret = null;
        try {
            ret = new ImageOpImpl(MDbmDriverManager.getConnection((InetAddress)addr, (int)port));
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public static final String getImageCodec(byte[] binary) throws Exception {
        return BaseImageConvertor.getImageFormat((InputStream)new ByteArrayInputStream(binary));
    }

    public static final int[] getImageWidthHeight(byte[] binary) throws Exception {
        ImageInfo img = ImageConvertor.loadImage((InputStream)new ByteArrayInputStream(binary));
        return new int[]{img.getWidth(), img.getHeight()};
    }
}

