/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cron;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.cron.CronBean;
import org.maachang.comet.httpd.engine.script.cron.CronConfig;
import org.maachang.comet.httpd.engine.script.cron.CronOneThread;
import org.maachang.util.thread.LoopThread;

public class CronTiemrThread
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(CronTiemrThread.class);
    private static final long NEXT_RES_TIME = 60000L;
    private static final long RES_TIME = 0L;
    private List<CronBean> res = null;
    private List<CronBean> executions = null;
    private List<CronOneThread> threads = null;
    private CronConfig config = null;
    private final boolean[] out = new boolean[1];

    public CronTiemrThread() throws Exception {
        this.res = Collections.synchronizedList(new ArrayList());
        this.executions = Collections.synchronizedList(new ArrayList());
        this.threads = Collections.synchronizedList(new ArrayList());
        this.config = new CronConfig();
        this.config.open();
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        super.stopThread();
        if (this.threads != null) {
            LOG.info((Object)"Cron\u5b9f\u884c\u30b9\u30ec\u30c3\u30c9\u5f85\u6a5f:\u958b\u59cb");
            long time = System.currentTimeMillis();
            int cnt = 0;
            while (true) {
                int len = this.threads.size();
                int i = len - 1;
                while (i >= 0) {
                    CronOneThread th = this.threads.get(i);
                    if (th == null || th.isStop()) {
                        this.threads.remove(i);
                    }
                    --i;
                }
                if (this.threads.size() <= 0) break;
                if (cnt % 100 == 99) {
                    LOG.info((Object)"Cron\u5b9f\u884c\u30b9\u30ec\u30c3\u30c9\u5f85\u6a5f\u4e2d");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++cnt;
            }
            time = System.currentTimeMillis() - time;
            LOG.info((Object)("Cron\u5b9f\u884c\u30b9\u30ec\u30c3\u30c9\u5f85\u6a5f:\u7d42\u4e86 - " + time + "ms"));
        }
        this.threads = null;
        this.res = null;
        this.executions = null;
    }

    protected void clear() {
        if (this.config != null) {
            this.config.close();
        }
        this.config = null;
        this.executions = null;
    }

    protected boolean execution() throws Exception {
        CronBean bean;
        Thread.sleep(50L);
        int len = this.config.size(this.out);
        this.updateConfig();
        if (len > 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(System.currentTimeMillis() + 0L));
            int i = 0;
            while (i < len) {
                bean = this.config.get(this.out, i);
                this.updateConfig();
                if (bean != null && bean.getLastExecutionTime() + 60000L <= System.currentTimeMillis() && (bean = this.useExecution(false, cal, bean)) != null) {
                    bean.setLastExecutionTime(System.currentTimeMillis());
                    this.res.add(bean);
                }
                ++i;
            }
        }
        len = this.threads.size();
        int i = len - 1;
        while (i >= 0) {
            try {
                CronOneThread th = this.threads.get(i);
                if (th == null || th.isStop()) {
                    this.threads.remove(i);
                }
            }
            catch (Exception th) {
                // empty catch block
            }
            --i;
        }
        len = this.res.size();
        if (len > 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(System.currentTimeMillis()));
            int i2 = len - 1;
            while (i2 >= 0) {
                bean = this.res.get(i2);
                if ((bean = this.useExecution(true, cal, bean)) != null) {
                    this.res.remove(i2);
                    CronOneThread th = new CronOneThread(this.executions, bean);
                    this.threads.add(th);
                    th.start();
                }
                --i2;
            }
        }
        return false;
    }

    private CronBean useExecution(boolean mode, Calendar cal, CronBean bean) throws Exception {
        CronBean x;
        int i;
        int len;
        if (!mode) {
            len = this.res.size();
            i = 0;
            while (i < len) {
                x = this.res.get(i);
                if (bean.equals(x)) {
                    return null;
                }
                ++i;
            }
        }
        len = this.executions.size();
        i = 0;
        while (i < len) {
            x = this.executions.get(i);
            if (bean.equals(x)) {
                return null;
            }
            ++i;
        }
        boolean check = false;
        if (bean.getMonth() != -1) {
            check = true;
            if (cal.get(2) + 1 != bean.getMonth()) {
                return null;
            }
        }
        if (bean.getWeek() != -1) {
            check = true;
            switch (cal.get(7)) {
                case 1: {
                    if (bean.getWeek() == 0) break;
                    return null;
                }
                case 2: {
                    if (bean.getWeek() == 1) break;
                    return null;
                }
                case 3: {
                    if (bean.getWeek() == 2) break;
                    return null;
                }
                case 4: {
                    if (bean.getWeek() == 3) break;
                    return null;
                }
                case 5: {
                    if (bean.getWeek() == 4) break;
                    return null;
                }
                case 6: {
                    if (bean.getWeek() == 5) break;
                    return null;
                }
                case 7: {
                    if (bean.getWeek() == 6) break;
                    return null;
                }
            }
        }
        if (bean.getDate() != -1 || bean.getDateTm() != -1) {
            check = true;
            if (bean.getDate() != -1 ? cal.get(5) != bean.getDate() : bean.getDateTm() != -1 && cal.get(5) % bean.getDateTm() != 0) {
                return null;
            }
        }
        if (bean.getHour() == -1 && bean.getHourTm() == -1) {
            if (check && cal.get(11) != 0) {
                return null;
            }
        } else {
            check = true;
            if (bean.getHour() != -1 ? cal.get(11) != bean.getHour() : bean.getHourTm() != -1 && cal.get(11) % bean.getHourTm() != 0) {
                return null;
            }
        }
        if (bean.getMinute() == -1 && bean.getMinuteTm() == -1) {
            if (check && cal.get(12) != 0) {
                return null;
            }
        } else {
            check = true;
            if (bean.getMinute() != -1 ? cal.get(12) != bean.getMinute() : bean.getMinuteTm() != -1 && cal.get(12) % bean.getMinuteTm() != 0) {
                return null;
            }
        }
        if (!check) {
            return null;
        }
        return bean;
    }

    private void updateConfig() {
        if (this.out[0]) {
            this.res.clear();
            this.executions.clear();
        }
    }
}

