/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.PublicCacheChild;
import org.maachang.comet.httpd.engine.PublicCacheChildThread;
import org.maachang.util.FileUtil;

class PublicCache {
    private static final Log LOG = LogFactory.getLog(PublicCache.class);
    private static final PublicCache SNGL = new PublicCache();
    private Map<String, PublicCacheChild> manager = null;
    private PublicCacheChildThread thread = null;
    private final Object sync = new Object();

    private PublicCache() {
        try {
            this.manager = Collections.synchronizedMap(new HashMap());
            this.thread = new PublicCacheChildThread(this.manager, this.sync);
        }
        catch (Exception e) {
            LOG.error((Object)"error", (Throwable)e);
        }
    }

    public static final PublicCache getInstance() {
        return SNGL;
    }

    public byte[] getData(String path) throws Exception {
        PublicCacheChild ch = this.get(path);
        if (ch == null) {
            return null;
        }
        return ch.getData();
    }

    public long getLastTime(String path) throws Exception {
        PublicCacheChild ch = this.get(path);
        if (ch == null) {
            return -1L;
        }
        return ch.getLastUpdateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicCacheChild get(String path) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        PublicCacheChild ret = null;
        if (!this.manager.containsKey(path)) {
            Object object = this.sync;
            synchronized (object) {
                if (FileUtil.isFileExists((String)path)) {
                    if (!FileUtil.isRead((String)path)) {
                        throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306f\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
                    }
                    ret = new PublicCacheChild(path, FileUtil.getFile((String)path), FileUtil.getLastTime((String)path));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("## \u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + path + "]\u3092\u30ad\u30e3\u30c3\u30b7\u30e5\u3057\u307e\u3057\u305f"));
                    }
                    this.manager.put(path, ret);
                }
            }
        } else {
            ret = this.manager.get(path);
            if (ret != null) {
                ret.update();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = true;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.thread.isStop();
        }
        return ret;
    }
}

