/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.script.image.ImageData;
import org.maachang.comet.httpd.engine.script.image.ImageManager;
import org.maachang.comet.httpd.engine.script.image.ImageOp;

public class ImageManagerReader {
    public static final String HEAD_IMAGE_MANAGER_URL = "/%00i%00m%00g_";
    private ImageData imageData = null;

    private ImageManagerReader() {
    }

    public ImageManagerReader(HttpdRequest request) throws Exception {
        long id = ImageManagerReader.convertId(request.getUrlPath());
        ImageOp man = ImageManager.getImageOp(false);
        if (!man.isImageId(id)) {
            throw new HttpdStateException(403, "\u6307\u5b9a\u753b\u50cf\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.imageData = man.get(id);
        man = null;
    }

    private static final long convertId(String url) throws Exception {
        long id = -1L;
        try {
            id = Long.parseLong(url.substring(HEAD_IMAGE_MANAGER_URL.length()));
        }
        catch (Exception e) {
            throw new HttpdStateException(403, "\u4e0d\u6b63\u306aURL\u3067\u3059");
        }
        return id;
    }

    public void destroy() {
        if (this.imageData != null) {
            this.imageData.destroy();
        }
        this.imageData = null;
    }

    public long getLastTime() {
        return this.imageData.getLastTime();
    }

    public HttpdResponse getResponse(HttpdRequest request) throws Exception {
        if (this.imageData == null) {
            return null;
        }
        HttpdResponse ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
        ret.setCookieSession(request);
        ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(this.imageData.getLastTime()));
        ret.getHeader().addHeader("Content-Type", String.valueOf(this.imageData.getMime()));
        ret.setHttpClose(false);
        ret.setGzip(false);
        ret.getOutput().write(this.imageData.getImage());
        this.destroy();
        return ret;
    }
}

