/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.scripts.ScriptManager;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScript;
import org.maachang.util.FileUtil;

class HttpdScriptManager
implements HttpdExecutionManager {
    private String appDirectory = null;

    private HttpdScriptManager() {
    }

    public HttpdScriptManager(String currentDirectory) throws Exception {
        this.appDirectory = ScriptDef.trimCurrentDirectory(currentDirectory) + "application/";
    }

    protected void finalize() throws Exception {
        this.appDirectory = null;
    }

    public HttpdResponse get(HttpdRequest request) throws Exception {
        return ScriptManager.execution(request, this.appDirectory);
    }

    public long getFileTime(String path) {
        if ((path = ScriptManager.trimScriptPath(path)) == null) {
            return -1L;
        }
        long ret = -1L;
        if (path.endsWith(".mttml")) {
            try {
                ret = TemplateScript.getTime(path);
                if (ret != -1L) {
                    return ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1L;
        }
        String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
        ret = FileUtil.getLastTime((String)(String.valueOf(fullPath) + ".ms"));
        if (ret != -1L) {
            return ret;
        }
        ret = FileUtil.getLastTime((String)(String.valueOf(fullPath) + "Controller" + ".ms"));
        if (ret != -1L) {
            return ret;
        }
        ret = FileUtil.getLastTime((String)(String.valueOf(fullPath) + ".mhtml"));
        if (ret != -1L) {
            return ret;
        }
        return -1L;
    }

    public boolean isPath(String path) {
        if ((path = ScriptManager.trimScriptPath(path)) == null) {
            return false;
        }
        if (path.endsWith(".mttml")) {
            try {
                if (TemplateScript.isTemplate(path)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
        if (FileUtil.isFileExists((String)(String.valueOf(fullPath) + ".ms"))) {
            return true;
        }
        if (FileUtil.isFileExists((String)(String.valueOf(fullPath) + "Controller" + ".ms"))) {
            return true;
        }
        return FileUtil.isFileExists((String)(String.valueOf(fullPath) + ".mhtml"));
    }

    public boolean isDirectory(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return FileUtil.isDirExists((String)(path = String.valueOf(this.appDirectory) + path));
    }

    public boolean isRead(String path) {
        if ((path = ScriptManager.trimScriptPath(path)) == null) {
            return false;
        }
        if (path.endsWith(".mttml")) {
            try {
                if (TemplateScript.isTemplate(path)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
        if (FileUtil.isRead((String)(String.valueOf(fullPath) + ".ms"))) {
            return true;
        }
        if (FileUtil.isRead((String)(String.valueOf(fullPath) + "Controller" + ".ms"))) {
            return true;
        }
        return FileUtil.isRead((String)(String.valueOf(fullPath) + ".mhtml"));
    }
}

