/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import org.maachang.comet.conf.IniFile;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.manager.GlobalManager;
import org.maachang.util.StringUtil;

public class EnvJavascript {
    private static String BUF_HTTP_URL = null;
    private static String BUF_HTTPS_URL = null;
    private static final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convert(HttpdRequest request, String string) throws Exception {
        HttpdSession session;
        if (string == null || string.length() <= 0) {
            return "";
        }
        if (request == null) {
            return string;
        }
        Object object = sync;
        synchronized (object) {
            if (BUF_HTTP_URL == null || BUF_HTTPS_URL == null) {
                BUF_HTTP_URL = EnvJavascript.getURL(request, false);
                BUF_HTTPS_URL = EnvJavascript.getURL(request, true);
            }
        }
        if (string.indexOf("$@@URL@@") != -1) {
            string = StringUtil.changeString((String)string, (String)"$@@URL@@", (String)(request.isSsl() ? BUF_HTTPS_URL : BUF_HTTP_URL));
        }
        if (string.indexOf("$@@HTTP_URL@@") != -1) {
            string = StringUtil.changeString((String)string, (String)"$@@HTTP_URL@@", (String)BUF_HTTP_URL);
        }
        if (string.indexOf("$@@HTTPS_URL@@") != -1) {
            string = StringUtil.changeString((String)string, (String)"$@@HTTPS_URL@@", (String)BUF_HTTPS_URL);
        }
        if (string.indexOf("$@@SESSION_ID@@") != -1 && (session = request.getSession()) != null && session.getSessionId() != null) {
            string = StringUtil.changeString((String)string, (String)"$@@SESSION_ID@@", (String)session.getSessionId());
        }
        return string;
    }

    private static final String getURL(HttpdRequest request, boolean mode) {
        int port;
        IniFile conf = (IniFile)GlobalManager.getInstance().get("CONFIG_MANAGER");
        String protocol = "";
        if (mode) {
            port = conf.getNumber("ssl", "port", 0);
            if (port == 443) {
                port = -1;
            }
            protocol = "https://";
        } else {
            port = conf.getNumber("net", "server-port", 0);
            if (port == 80) {
                port = -1;
            }
            protocol = "http://";
        }
        String host = request.getHeader().getHeader("Host", 0);
        int p = host.indexOf(":");
        if (p >= 0) {
            host = host.substring(0, p);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(protocol).append(host);
        if (port != -1) {
            buf.append(":").append(port);
        }
        return buf.toString();
    }
}

