/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import org.maachang.comet.httpd.engine.HttpdEngine;
import org.maachang.comet.net.NetService;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.manager.GlobalManager;
import org.maachang.rawio.Cpu;

public class MSystem {
    private static final long NEXT_TIME = 3000L;
    private double useCpu = 0.0;
    private int processId = -1;
    private static final MSystem SNGL = new MSystem();
    private boolean processIdFlag = false;
    private long next = -1L;

    private static final NetService netService() {
        return ((HttpdEngine)GlobalManager.getInstance().get("HTTPD")).getNetService();
    }

    private static final RecordFactory recordFactory() {
        return (RecordFactory)GlobalManager.getInstance().get("DBMS_POOL");
    }

    public static int getNetUsePooling() {
        return MSystem.netService().getNioService().getUsePooling();
    }

    public static int getNetActivePooling() {
        return MSystem.netService().getNioService().getActivePooling();
    }

    public static int getDbMax() {
        return MSystem.recordFactory().getConnectionManager().getMax();
    }

    public static int getDbActives() {
        return MSystem.recordFactory().getConnectionManager().getActives();
    }

    public static int getDbIdle() {
        return MSystem.recordFactory().getConnectionManager().getIdle();
    }

    public static final double useCpu() {
        return MSystem.getInstance()._useCpu();
    }

    public static final int getProcessId() {
        return MSystem.getInstance()._getProcessId();
    }

    protected static final MSystem getInstance() {
        return SNGL;
    }

    private synchronized int _getProcessId() {
        if (this.processIdFlag) {
            return this.processId;
        }
        this.processId = Cpu.getProcessId();
        this.processIdFlag = true;
        return this.processId;
    }

    private synchronized double _useCpu() {
        long t = System.currentTimeMillis();
        if (t >= this.next + 3000L) {
            this.useCpu = Cpu.useCpu();
            this.next = t;
        }
        return this.useCpu;
    }
}

