/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.Datum;

public class BINARY_FLOAT
extends Datum {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:30_PST_2006";

    public BINARY_FLOAT() {
    }

    public BINARY_FLOAT(byte[] byArray) {
        super(byArray);
    }

    public BINARY_FLOAT(float f) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f));
    }

    public BINARY_FLOAT(Float f) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f.floatValue()));
    }

    public Object toJdbc() throws SQLException {
        return new Float(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Float") == 0;
    }

    public String stringValue() {
        String string = Float.toString(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
        return string;
    }

    public Object makeJdbcArray(int n) {
        return new Float[n];
    }

    static byte[] floatToCanonicalFormatBytes(float f) {
        float f2 = f;
        if (f2 == 0.0f) {
            f2 = 0.0f;
        } else if (f2 != f2) {
            f2 = Float.NaN;
        }
        int n = Float.floatToIntBits(f2);
        byte[] byArray = new byte[4];
        int n2 = n;
        int n3 = n >>= 8;
        int n4 = n >>= 8;
        int n5 = n >>= 8;
        if ((n5 & 0x80) == 0) {
            n5 |= 0x80;
        } else {
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
            n3 ^= 0xFFFFFFFF;
            n2 ^= 0xFFFFFFFF;
        }
        byArray[3] = (byte)n2;
        byArray[2] = (byte)n3;
        byArray[1] = (byte)n4;
        byArray[0] = (byte)n5;
        return byArray;
    }

    static float canonicalFormatBytesToFloat(byte[] byArray) {
        int n = byArray[0];
        int n2 = byArray[1];
        int n3 = byArray[2];
        int n4 = byArray[3];
        if ((n & 0x80) != 0) {
            n &= 0x7F;
            n2 &= 0xFF;
            n3 &= 0xFF;
            n4 &= 0xFF;
        } else {
            n = ~n & 0xFF;
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
        }
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        return Float.intBitsToFloat(n5);
    }
}

