/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.maachang.report.CellPosition;
import org.maachang.report.CellPositionList;
import org.maachang.report.CellStyleList;
import org.maachang.report.ExcelUtil;
import org.maachang.util.FileUtil;

class ExcelSheet {
    public static final int CELL_BLANK = 0;
    public static final int CELL_NUMBER = 1;
    public static final int CELL_STRING = 2;
    public static final int CELL_BOOLEAN = 3;
    public static final int CELL_DATE = 4;
    private HSSFWorkbook work = null;
    private HSSFSheet sheet = null;
    private String sheetName = null;

    public ExcelSheet() {
    }

    public ExcelSheet(String name, String sheetName) throws Exception {
        this.open(name, sheetName);
    }

    public void open(String name, String sheetName) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!name.endsWith(".xls")) {
            name = String.valueOf(name) + ".xls";
        }
        if (!FileUtil.isFileExists((String)name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (!FileUtil.isRead((String)name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (sheetName == null || (sheetName = sheetName.trim()).length() <= 0) {
            sheetName = "Sheet1";
        }
        this.destroy();
        InputStream ins = null;
        try {
            try {
                ins = new BufferedInputStream(new FileInputStream(name));
                POIFSFileSystem fs = new POIFSFileSystem(ins);
                this.work = new HSSFWorkbook(fs);
                this.sheetName = sheetName;
                this.sheet = this.work.getSheet(sheetName);
                ins.close();
                ins = null;
            }
            catch (Exception e) {
                this.destroy();
                throw e;
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            ins = null;
        }
    }

    public void destroy() {
        this.work = null;
        this.sheet = null;
        this.sheetName = null;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public boolean isUse() {
        return this.work != null;
    }

    public byte[] getBytes() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        ByteArrayOutputStream bo = null;
        try {
            bo = new ByteArrayOutputStream();
            this.work.write((OutputStream)bo);
            bo.flush();
            byte[] ret = bo.toByteArray();
            bo.close();
            bo = null;
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void output(String name) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        OutputStream bo = null;
        try {
            bo = new BufferedOutputStream(new FileOutputStream(name));
            this.work.write(bo);
            bo.flush();
            bo.close();
            bo = null;
        }
        finally {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setCell(int x, int y, Object data) throws Exception {
        HSSFCell cell;
        HSSFRow row;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (x <= -1 || x > Short.MAX_VALUE || y <= -1 || y > 65535) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5ea7\u6a19\u306f\u4e0d\u6b63\u3067\u3059[x:" + x + " y:" + y + "]");
        }
        if (data == null) {
            data = "";
        }
        if ((row = this.sheet.getRow(y)) == null) {
            row = this.sheet.createRow(y);
        }
        if ((cell = row.getCell((short)x)) == null) {
            cell = row.createCell((short)x);
        }
        if (data instanceof String) {
            cell.setCellValue(new HSSFRichTextString((String)data));
        } else if (data instanceof Boolean) {
            cell.setCellValue(((Boolean)data).booleanValue());
        } else if (data instanceof Integer) {
            cell.setCellValue((double)((Integer)data).intValue());
        } else if (data instanceof Double) {
            cell.setCellValue(((Double)data).doubleValue());
        } else if (data instanceof Date) {
            cell.setCellValue((Date)data);
        } else {
            throw new IllegalArgumentException("\u6307\u5b9a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30bf\u30a4\u30d7[" + data.getClass().getName() + "]\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
        }
    }

    public void setCell(String x, int y, Object data) throws Exception {
        this.setCell(ExcelUtil.getPosAz(x), y, data);
    }

    public Object getCell(int x, int y) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (x <= -1 || x > Short.MAX_VALUE || y <= -1 || y > 65535) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5ea7\u6a19\u306f\u4e0d\u6b63\u3067\u3059[x:" + x + " y:" + y + "]");
        }
        HSSFRow row = this.sheet.getRow(y);
        if (row == null) {
            throw new IllegalArgumentException("Y\u5ea7\u6a19[" + y + "]\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        HSSFCell cell = row.getCell((short)x);
        if (cell == null) {
            throw new IllegalArgumentException("\u5ea7\u6a19[x:" + x + " y:" + y + "]\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        Object ret = null;
        int type = cell.getCellType();
        switch (type) {
            case 3: {
                ret = "";
                break;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                    ret = cell.getDateCellValue();
                    break;
                }
                ret = cell.getNumericCellValue();
                break;
            }
            case 1: {
                HSSFRichTextString tx = cell.getRichStringCellValue();
                if (tx == null) {
                    ret = "";
                    break;
                }
                ret = tx.getString();
                break;
            }
            case 4: {
                ret = cell.getBooleanCellValue();
            }
        }
        return ret;
    }

    public Object getCell(String x, int y) throws Exception {
        return this.getCell(ExcelUtil.getPosAz(x), y);
    }

    public int getCellType(int x, int y) {
        if (!this.isUse()) {
            return -1;
        }
        if (x <= -1 || x > Short.MAX_VALUE || y <= -1 || y > 65535) {
            return -1;
        }
        HSSFRow row = this.sheet.getRow(y);
        if (row == null) {
            return -1;
        }
        HSSFCell cell = row.getCell((short)x);
        if (cell == null) {
            return -1;
        }
        int type = cell.getCellType();
        switch (type) {
            case 3: {
                return 0;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                    return 4;
                }
                return 1;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }

    public Object getCellType(String x, int y) {
        return this.getCellType(ExcelUtil.getPosAz(x), y);
    }

    public void pushRow(int y, int n) throws Exception {
        if (y <= -1 || y >= 65536) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5ea7\u6a19\u306f\u4e0d\u6b63\u3067\u3059[y:" + y + "]");
        }
        this.sheet.shiftRows(y, this.sheet.getLastRowNum(), n);
    }

    public CellPositionList getCellPositionList(CellStyleList csList) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        CellPositionList ret = new CellPositionList(csList);
        Iterator it = this.sheet.rowIterator();
        while (it.hasNext()) {
            HSSFRow row = (HSSFRow)it.next();
            if (row == null) continue;
            for (HSSFCell cell : row) {
                String s;
                HSSFRichTextString tx;
                if (cell == null || (tx = cell.getRichStringCellValue()) == null || (s = tx.toString()) == null || (s = s.trim()).length() <= 0 || (!s.startsWith("${") || !s.endsWith("}")) && (!s.startsWith("$(") || !s.endsWith(")"))) continue;
                s = s.startsWith("${") ? s.substring("${".length(), s.length() - "}".length()).trim() : s.substring("$(".length(), s.length() - ")".length()).trim();
                int x = cell.getCellNum() & 0xFFFF;
                int y = row.getRowNum();
                CellPosition pos = new CellPosition(x, y, s);
                ret.put(pos);
                cell.setCellValue(new HSSFRichTextString(""));
            }
        }
        return ret;
    }
}

