/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SheetNameFormatter {
    private static final String BIFF8_LAST_COLUMN = "IV";
    private static final int BIFF8_LAST_COLUMN_TEXT_LEN = "IV".length();
    private static final String BIFF8_LAST_ROW = String.valueOf(65536);
    private static final int BIFF8_LAST_ROW_TEXT_LEN = BIFF8_LAST_ROW.length();
    private static final char DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Za-z])+[0-9]+");

    private SheetNameFormatter() {
    }

    public static String format(String rawSheetName) {
        StringBuffer sb = new StringBuffer(rawSheetName.length() + 2);
        SheetNameFormatter.appendFormat(sb, rawSheetName);
        return sb.toString();
    }

    public static void appendFormat(StringBuffer out, String rawSheetName) {
        boolean needsQuotes = SheetNameFormatter.needsDelimiting(rawSheetName);
        if (needsQuotes) {
            out.append('\'');
            SheetNameFormatter.appendAndEscape(out, rawSheetName);
            out.append('\'');
        } else {
            out.append(rawSheetName);
        }
    }

    private static void appendAndEscape(StringBuffer sb, String rawSheetName) {
        int len = rawSheetName.length();
        for (int i = 0; i < len; ++i) {
            char ch = rawSheetName.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
    }

    private static boolean needsDelimiting(String rawSheetName) {
        int len = rawSheetName.length();
        if (len < 1) {
            throw new RuntimeException("Zero length string is an invalid sheet name");
        }
        if (Character.isDigit(rawSheetName.charAt(0))) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            char ch = rawSheetName.charAt(i);
            if (!SheetNameFormatter.isSpecialChar(ch)) continue;
            return true;
        }
        return Character.isLetter(rawSheetName.charAt(0)) && Character.isDigit(rawSheetName.charAt(len - 1)) && SheetNameFormatter.nameLooksLikePlainCellReference(rawSheetName);
    }

    static boolean isSpecialChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        switch (ch) {
            case '_': {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                throw new RuntimeException("Illegal character (0x" + Integer.toHexString(ch) + ") found in sheet name");
            }
        }
        return true;
    }

    static boolean cellReferenceIsWithinRange(String rawSheetName, int numberOfLetters) {
        String colStr;
        if (numberOfLetters > BIFF8_LAST_COLUMN_TEXT_LEN) {
            return false;
        }
        int nDigits = rawSheetName.length() - numberOfLetters;
        if (nDigits > BIFF8_LAST_ROW_TEXT_LEN) {
            return false;
        }
        if (numberOfLetters == BIFF8_LAST_COLUMN_TEXT_LEN && (colStr = rawSheetName.substring(0, BIFF8_LAST_COLUMN_TEXT_LEN).toUpperCase()).compareTo(BIFF8_LAST_COLUMN) > 0) {
            return false;
        }
        return nDigits != BIFF8_LAST_ROW_TEXT_LEN || (colStr = rawSheetName.substring(numberOfLetters)).compareTo(BIFF8_LAST_ROW) <= 0;
    }

    static boolean nameLooksLikePlainCellReference(String rawSheetName) {
        Matcher matcher = CELL_REF_PATTERN.matcher(rawSheetName);
        if (!matcher.matches()) {
            return false;
        }
        String lettersPrefix = matcher.group(1);
        return SheetNameFormatter.cellReferenceIsWithinRange(rawSheetName, lettersPrefix.length());
    }
}

