/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dbm.engine.MDbmDefine;

public class MDbmEnv {
    public static final int HASH;
    public static final int ONE_SECTOR_BY_SECTOR_SIZE;

    static {
        Log logOut = LogFactory.getLog(MDbmEnv.class);
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)"## MDbm version:b1.14");
        }
        int n = 20;
        if (System.getProperty("mdbm.hash") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.hash"));
                if (n >= 26) {
                    n = 26;
                } else if (n <= 8) {
                    n = 8;
                }
            }
            catch (Exception e) {
                n = 20;
            }
        }
        int hashSize = 1048575;
        switch (n) {
            case 8: {
                hashSize = 255;
                break;
            }
            case 9: {
                hashSize = 511;
                break;
            }
            case 10: {
                hashSize = 1023;
                break;
            }
            case 11: {
                hashSize = 2047;
                break;
            }
            case 12: {
                hashSize = 4095;
                break;
            }
            case 13: {
                hashSize = 8191;
                break;
            }
            case 14: {
                hashSize = 16383;
                break;
            }
            case 15: {
                hashSize = Short.MAX_VALUE;
                break;
            }
            case 16: {
                hashSize = 65535;
                break;
            }
            case 17: {
                hashSize = 131071;
                break;
            }
            case 18: {
                hashSize = 262143;
                break;
            }
            case 19: {
                hashSize = 524287;
                break;
            }
            case 20: {
                hashSize = 1048575;
                break;
            }
            case 21: {
                hashSize = 0x1FFFFF;
                break;
            }
            case 22: {
                hashSize = 0x3FFFFF;
                break;
            }
            case 23: {
                hashSize = 0x7FFFFF;
                break;
            }
            case 24: {
                hashSize = 0xFFFFFF;
                break;
            }
            case 25: {
                hashSize = 0x1FFFFFF;
                break;
            }
            case 26: {
                hashSize = 0x3FFFFFF;
                break;
            }
            case 27: {
                hashSize = 0x7FFFFFF;
                break;
            }
            case 28: {
                hashSize = 0xFFFFFFF;
                break;
            }
            case 29: {
                hashSize = 0x1FFFFFFF;
                break;
            }
            case 30: {
                hashSize = 0x3FFFFFFF;
                break;
            }
            case 31: {
                hashSize = Integer.MAX_VALUE;
            }
        }
        HASH = hashSize + 1;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.HASH:" + (hashSize + 1)));
        }
        n = 500000;
        if (System.getProperty("mdbm.sector.file") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.sector.file"));
                if (n >= 3500000) {
                    n = 3500000;
                } else if (n <= 10000) {
                    n = 10000;
                }
            }
            catch (Exception e) {
                n = 500000;
            }
        }
        if ((n = n / 10000 * 10000) <= 10000) {
            n = 10000;
        }
        ONE_SECTOR_BY_SECTOR_SIZE = n;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.ONE_SECTOR_BY_SECTOR_SIZE:" + n));
        }
    }
}

