/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.maachang.dbm.engine.M2OneFileSector;

class M2SectorList {
    private M2OneFileSector[] list = null;

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.list != null) {
            int len = this.list.length;
            int i = 0;
            while (i < len) {
                M2OneFileSector o = this.list[i];
                if (o != null) {
                    o.destroy();
                }
                this.list[i] = null;
                ++i;
            }
            this.list = null;
        }
    }

    public synchronized void put(int no, M2OneFileSector f) {
        if (this.list == null) {
            this.list = new M2OneFileSector[no + 1];
            this.list[no] = f;
        } else {
            if (this.list.length <= no) {
                M2OneFileSector[] t = new M2OneFileSector[no + 1];
                System.arraycopy(this.list, 0, t, 0, this.list.length);
                this.list = t;
            }
            this.list[no] = f;
        }
    }

    public synchronized M2OneFileSector get(int no) {
        if (this.list == null || this.list.length <= no) {
            return null;
        }
        return this.list[no];
    }

    public synchronized int size() {
        return this.list != null ? this.list.length : 0;
    }
}

