/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.maachang.dbm.MBinary;
import org.maachang.dbm.MTransaction;
import org.maachang.dbm.engine.M2Engine;
import org.maachang.dbm.engine.M2NextKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDbmTranEnum
implements Enumeration<byte[]> {
    private M2Engine engine = null;
    private M2NextKey next = null;
    private Map<MBinary, MTransaction> man = null;
    private List<MTransaction> putTrans = null;
    private int pos = -1;

    protected MDbmTranEnum(M2Engine engine, Map<MBinary, MTransaction> man) {
        this.engine = engine;
        this.man = man;
    }

    protected void finalize() throws Exception {
        this.engine = null;
        this.next = null;
        this.man = null;
        this.putTrans = null;
        this.pos = -1;
    }

    @Override
    public boolean hasMoreElements() {
        boolean ret = false;
        if (this.pos <= -1 && !(ret = this.hasFile())) {
            this.createTranList();
        }
        if (this.pos >= 0) {
            ret = this.hasTran();
        }
        return ret;
    }

    @Override
    public byte[] nextElement() {
        byte[] ret = null;
        if (this.pos <= -1 && (ret = this.nextFile()) == null) {
            this.createTranList();
        }
        if (this.pos >= 0) {
            ret = this.nextTran();
        }
        return ret;
    }

    private boolean hasFile() {
        boolean ret;
        block3: {
            ret = false;
            try {
                MTransaction t;
                M2NextKey n = this.next;
                do {
                    if ((n = this.engine.next(n)) != null) continue;
                    ret = false;
                    break block3;
                } while ((t = this.man.get(new MBinary(n.getKey()))) != null && t.getType() == 2);
                ret = true;
            }
            catch (Exception e) {
                ret = false;
            }
        }
        return ret;
    }

    private boolean hasTran() {
        return this.pos > -1 && this.putTrans != null && this.putTrans.size() > this.pos;
    }

    private byte[] nextFile() {
        byte[] ret;
        block3: {
            ret = null;
            try {
                MTransaction t;
                do {
                    this.next = this.engine.next(this.next);
                    if (this.next != null) continue;
                    ret = null;
                    break block3;
                } while ((t = this.man.get(new MBinary(this.next.getKey()))) != null && t.getType() == 2);
                ret = this.next.getKey();
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    private byte[] nextTran() {
        if (this.pos <= -1 || this.putTrans == null || this.putTrans.size() <= this.pos) {
            return null;
        }
        byte[] ret = this.putTrans.get(this.pos).getKey().getBinary();
        ++this.pos;
        return ret;
    }

    private void createTranList() {
        if (this.pos > 0) {
            return;
        }
        this.pos = 0;
        if (this.man.size() <= 0) {
            return;
        }
        ArrayList<MTransaction> lst = new ArrayList<MTransaction>();
        Object[] o = this.man.keySet().toArray();
        int len = o.length;
        int i = 0;
        while (i < len) {
            MTransaction t = this.man.get((MBinary)o[i]);
            if (t.getType() == 1) {
                lst.add(t);
            }
            ++i;
        }
        o = null;
        if (lst.size() <= 0) {
            lst = null;
        }
        this.putTrans = lst;
    }
}

