/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.mapping;

import java.io.IOException;
import org.maachang.rawio.mapping.MappingChild;

class MappingManager {
    private MappingChild[] mappings = null;
    private int allLength = -1;

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected synchronized void destroy() {
        if (this.mappings != null) {
            int len = this.mappings.length;
            int i = 0;
            while (i < len) {
                this.mappings[i].destroy();
                this.mappings[i] = null;
                ++i;
            }
        }
        this.mappings = null;
    }

    public synchronized MappingChild add(int sector, int startPos, int length) throws Exception {
        MappingChild ret = null;
        if (this.mappings != null) {
            int len = this.mappings.length;
            int endPos = startPos + length;
            int i = 0;
            while (i < len) {
                MappingChild ch = this.mappings[i];
                if (ch.isPosition(startPos) || ch.isPosition(endPos)) {
                    throw new IOException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3(start:" + startPos + " length:" + length + ")\u306f\u4ed6\u306eMapping\u3068\u7af6\u5408\u3057\u307e\u3059");
                }
                ++i;
            }
            ret = new MappingChild(sector, startPos, length);
            MappingChild[] m = new MappingChild[len + 1];
            System.arraycopy(this.mappings, 0, m, 0, len);
            m[len] = ret;
            this.mappings = m;
            this.allLength += length;
        } else {
            ret = new MappingChild(sector, startPos, length);
            MappingChild[] m = new MappingChild[]{ret};
            this.mappings = m;
            this.allLength = length;
        }
        return ret;
    }

    public synchronized MappingChild get(int no) {
        if (this.mappings != null) {
            int len = this.mappings.length;
            int i = 0;
            while (i < len) {
                if (this.mappings[i].isPosition(no)) {
                    return this.mappings[i];
                }
                ++i;
            }
        }
        return null;
    }

    public synchronized MappingChild getArray(int no) {
        if (this.mappings != null) {
            if (no < 0 || no >= this.mappings.length) {
                return null;
            }
            return this.mappings[no];
        }
        return null;
    }

    public synchronized boolean isMapping(int no) {
        if (this.mappings != null) {
            int len = this.mappings.length;
            int i = 0;
            while (i < len) {
                if (this.mappings[i].isPosition(no)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public synchronized int getUpdateSize() {
        int ret = 0;
        if (this.mappings != null) {
            int len = this.mappings.length;
            int i = 0;
            while (i < len) {
                ret += this.mappings[i].updateLength();
                ++i;
            }
        }
        return ret;
    }

    public synchronized int length() {
        return this.mappings != null ? this.mappings.length : 0;
    }

    public synchronized int mappingSize() {
        return this.allLength;
    }
}

