package org.maachang.rawio.async ;

import org.maachang.rawio.Rawio;

/**
 * Block書込み要素.
 * 
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
class ASyncElement {
    
    /**
     * 書込み先Rawio.
     */
    private Rawio raw = null ;
    
    /**
     * ロックオブジェクト.
     */
    private ASyncWriteLock lock = null ;
    
    /**
     * 書き込みデータ.
     */
    private byte[] data = null ;
    
    /**
     * 書き込みセクタ位置.
     */
    private int no = -1 ;
    
    /**
     * コンストラクタ.
     */
    private ASyncElement() {
        
    }
    
    /**
     * コンストラクタ.
     * @param raw 書込み先Rawオブジェクトを設定します.
     * @param lock 書込みロックオブジェクトを設定します.
     * @param data 書き込みデータを設定します.
     * @param no 書き込みセクタ位置を設定します.
     */
    public ASyncElement( Rawio raw,ASyncWriteLock lock,byte[] data,int no ) {
        this.raw = raw ;
        this.lock = lock ;
        this.data = data ;
        this.no = no ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        this.raw = null ;
        this.lock = null ;
        this.data = null ;
    }
    
    /**
     * Rawio を取得.
     * @return Rawio が返されます.
     */
    public Rawio getRaw() {
        return raw ;
    }
    
    /**
     * lock を取得.
     * @return ASyncWriteLock が返されます.
     */
    public ASyncWriteLock getLock() {
        return lock ;
    }
    
    /**
     * data を取得.
     * @return data が返されます.
     */
    public byte[] getData() {
        return data;
    }
    
    /**
     * no を取得.
     * @return no が返されます.
     */
    public int getNo() {
        return no;
    }
    
}
