package org.maachang.rawio ;

/**
 * rawio定義.
 *  
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
public abstract class RawioDefine {
    private RawioDefine() {}
    
    /**
     * バージョン.
     */
    public static final String VERSION = "b1.01" ;
    
    /**
     * プロパティ定義.
     */
    public static final String PROPERTY_NAME = "org.maachang.rawio.dir" ;
    
    /**
     * ライブラリ読み込み条件.
     */
    protected static final String LIB_MODE = "org.maachang.rawio.native" ;
    
    /**
     * RawI/O.
     */
    protected static final String RAW_NAME = "rawio" ;
    
    /**
     * ノーマルI/O.
     */
    protected static final String NORMAL_NAME = "normalio" ;
    
    /**
     * Windowsライブラリ拡張子.
     */
    protected static final String WINDOWS_LIB_PLUS = ".dll" ;
    
    /**
     * Linuxライブラリ拡張子.
     */
    protected static final String LINUX_LIB_PLUS = ".so" ;
    
    /**
     * Nativeライブラリパス.
     */
    protected static final String NATIVE_PACKAGE = "org/maachang/rawio/native/" ;
    
    /**
     * デフォルトライブラリ格納ディレクトリ名.
     */
    protected static final String DEFAULT_DIR = ".lib_work" ;
    
}
