package org.maachang.session.engine ;

import java.util.HashSet;

/**
 * セッションIDロック.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
class SessionIdLock {
    
    /**
     * ロックスリープ時間.
     */
    private static final long SLEEP_TIME = 5L ;
    
    /**
     * ロック名群.
     */
    private HashSet<String> manager = null ;
    
    /**
     * コンストラクタ.
     */
    public SessionIdLock() {
        manager = new HashSet<String>() ;
    }
    
    /**
     * 指定名でロック.
     * @param name 対象の名前を設定します.
     * @exceptino InterruptedException スレッド割り込み例外.
     */
    public void lock( String name ) throws InterruptedException {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        for( ;; ) {
            synchronized( this ) {
                if( manager.contains( name ) == false ) {
                    manager.add( name ) ;
                    break ;
                }
            }
            Thread.sleep( SLEEP_TIME ) ;
        }
    }
    
    /**
     * 指定名でアンロック.
     * @param name 対象の名前を設定します.
     */
    public void unlock( String name ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        synchronized( this ) {
            manager.remove( name ) ;
        }
    }
}
