package org.maachang.comet.net.nio ;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;

/**
 * １つのコネクションオブジェクト.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class ConnectionInfoImpl implements ConnectionInfo {
    
    private KeepAliveBean keepAlive = null ;
    private NioElement element = null ;
    private InetAddress address = null ;
    private int port = -1 ;
    private boolean cloesFlag = false ;
    
    private ConnectionInfoImpl() {
        
    }
    
    public ConnectionInfoImpl( NioElement element ) {
        if( element == null ) {
            return ;
        }
        KeepAliveBean keepAlive = ( KeepAliveBean )element.getObject() ;
        if( keepAlive == null ) {
            keepAlive = KeepAliveFactory.getInstance().getBean() ;
            element.setObject( keepAlive ) ;
        }
        this.element = element ;
        this.keepAlive = keepAlive ;
        this.address = element.getChannel().socket().getInetAddress() ;
        this.port = element.getChannel().socket().getPort() ;
    }
    
    public void destroy() {
        if( element != null ) {
            element.destroy() ;
        }
        element = null ;
        keepAlive = null ;
        address = null ;
        port = -1 ;
    }
    
    public NioElement getElement() {
        if( isUse() == false ) {
            return null ;
        }
        return element ;
    }
    
    public void setTimeout( int time ) {
        keepAlive.setTime( time ) ;
    }
    
    public long getTimeout() {
        return keepAlive.getTime() ;
    }
    
    public int getCount() {
        return keepAlive.getCount() ;
    }
    
    public OutputStream getOutputStream()
        throws Exception {
        if( isUse() == false ) {
            return null ;
        }
        return new NioOutputStream( element ) ;
    }
    
    public InputStream getInputStream()
        throws Exception {
        if( isUse() == false ) {
            return null ;
        }
        return new NioInputStream( element ) ;
    }
    
    public InputStream getInputStream( long timeout )
        throws Exception {
        if( isUse() == false ) {
            return null ;
        }
        return new NioInputStream( element,timeout ) ;
    }
    
    public InetAddress getInetAddress() {
        return address ;
    }
    
    public int getPort() {
        return port ;
    }
    
    public void setCloseFlag( boolean mode ) {
        cloesFlag = mode ;
    }
    
    public boolean recyclingConnection() {
        if( isUse() == false ) {
            return false ;
        }
        int cnt = keepAlive.getCount() - 1 ;
        keepAlive.setCount( cnt ) ;
        if( cnt <= 0 ) {
            return false ;
        }
        element.setExecutionFlag( false ) ;
        return true ;
    }
    
    public boolean isCloseFlag() {
        return cloesFlag ;
    }
    
    public boolean isUse() {
        boolean ret = ( element == null || element.getChannel() == null ||
            element.getChannel().isConnected() == false ) ? false : true ;
        if( ret == false ) {
            if( element != null ) {
                element.destroy() ;
            }
        }
        return ret ;
    }
}
