package org.maachang.comet.httpd.engine.script;

import org.maachang.comet.ServiceDef;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.httpd.engine.script.cache.StartupScript;
import org.maachang.manager.GlobalManager;

/**
 * リクエストに対する実行用ターゲットスクリプト.
 * 
 * @version 2007/11/28
 * @author masahito suzuki
 * @since MaachangComet 1.03
 */
public class ExecutionStartup {
    
    /**
     * 開始処理.
     */
    public static final void init() throws Exception {
        IniFile ini = ( IniFile )GlobalManager.getValue( ServiceDef.MANAGER_BY_CONFIG ) ;
        StartupScript.startup( ini ) ;
    }
    
    /**
     * 終了処理.
     */
    public static final void destroy() {
        try {
            IniFile ini = ( IniFile )GlobalManager.getValue( ServiceDef.MANAGER_BY_CONFIG ) ;
            StartupScript.shutdown( ini ) ;
        } catch( Exception e ) {
        }
    }
    
    
}
