/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.net;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.maachang.session.client.net.ClientSessionCacheThread;

public class ClientSessionCache {
    private static final int TIMEOUT = 3500;
    private Map<String, Long> map = null;
    private ClientSessionCacheThread thread = null;
    private final Object sync = new Object();

    protected ClientSessionCache() throws Exception {
        try {
            this.map = Collections.synchronizedMap(new HashMap());
            this.thread = new ClientSessionCacheThread(this.sync, this.map, 3500L);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.stopThread();
            }
            this.thread = null;
            if (this.map != null) {
                this.map.clear();
            }
            this.map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String sessionId) {
        Object object = this.sync;
        synchronized (object) {
            if (this.isUse()) {
                if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
                    return;
                }
                this.map.put(sessionId, new Long(System.currentTimeMillis()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String sessionId) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return;
            }
            if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
                return;
            }
            if (this.map.containsKey(sessionId)) {
                this.map.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String sessionId) {
        Object object = this.sync;
        synchronized (object) {
            block9: {
                block8: {
                    block7: {
                        if (this.isUse()) break block7;
                        return false;
                    }
                    if (sessionId != null && (sessionId = sessionId.trim()).length() == 48) break block8;
                    return false;
                }
                Long time = this.map.get(sessionId);
                if (time == null) break block9;
                if (time + 3500L <= System.currentTimeMillis()) {
                    this.map.remove(sessionId);
                    break block9;
                }
                this.map.put(sessionId, new Long(System.currentTimeMillis()));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        Object object = this.sync;
        synchronized (object) {
            return this.map != null && this.thread != null && !this.thread.isStop();
        }
    }
}

