/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jsr.script.javascript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import org.maachang.jsr.script.javascript.RhinoScriptEngine;
import org.maachang.jsr.script.util.ScriptEngineFactoryBase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptEngineFactory
extends ScriptEngineFactoryBase {
    public static final String USE_INTERPRETER_SYSTEM_PROPERTY = "com.sun.phobos.javascript.useInterpreter";
    private Properties properties = null;
    private boolean initialized = false;
    private ContextFactory.Listener listener;
    private static List<String> names = new ArrayList<String>(7);
    private static List<String> mimeTypes;
    private static List<String> extensions;

    static {
        names.add("jss");
        names = Collections.unmodifiableList(names);
        mimeTypes = new ArrayList<String>(4);
        mimeTypes.add("application/jss");
        mimeTypes.add("text/jss");
        mimeTypes = Collections.unmodifiableList(mimeTypes);
        extensions = new ArrayList<String>(1);
        extensions.add("jss");
        extensions = Collections.unmodifiableList(extensions);
    }

    public RhinoScriptEngineFactory() {
    }

    public RhinoScriptEngineFactory(ContextFactory.Listener listener) {
        this.listener = listener;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return "javascript";
        }
        if (key.equals("javax.script.engine")) {
            return "Mozilla Rhino(RhinoScriptEngine)";
        }
        if (key.equals("javax.script.engine_version")) {
            return "1.7RC1";
        }
        if (key.equals("javax.script.language")) {
            return "ECMAScript";
        }
        if (key.equals("javax.script.language_version")) {
            return "1.7";
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        RhinoScriptEngine ret = new RhinoScriptEngine();
        ret.setEngineFactory(this);
        return ret;
    }

    public void initialize() {
        if (!this.initialized) {
            if ("true".equals(this.getProperty(USE_INTERPRETER_SYSTEM_PROPERTY)) && !ContextFactory.hasExplicitGlobal()) {
                ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

                    protected Context makeContext() {
                        Context cx = super.makeContext();
                        cx.setOptimizationLevel(-1);
                        return cx;
                    }
                });
            }
            if (this.listener != null) {
                ContextFactory.getGlobal().addListener(this.listener);
            }
            this.initialized = true;
        }
    }

    public void destroy() {
        if (this.initialized) {
            if (this.listener != null) {
                ContextFactory.getGlobal().removeListener(this.listener);
            }
            this.initialized = false;
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private String getProperty(String key) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    private String getProperty(String name, String defaultValue) {
        String s = this.getProperty(name);
        return s == null ? defaultValue : s;
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj).append(".").append(method).append("(");
        int len = args.length;
        if (len == 0) {
            buf.append(")");
            return buf.toString();
        }
        int i = 0;
        while (i < len) {
            buf.append(args[i]);
            if (i != len - 1) {
                buf.append(",");
            } else {
                buf.append(")");
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        int len = statements.length;
        String ret = "";
        int i = 0;
        while (i < len) {
            ret = String.valueOf(ret) + statements[i] + ";";
            ++i;
        }
        return ret;
    }

    public static void main(String[] args) {
        RhinoScriptEngineFactory fact = new RhinoScriptEngineFactory();
        System.out.println(fact.getParameter("javax.script.engine_version"));
    }
}

