/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jsr.script.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.maachang.jsr.script.javascript.RhinoScriptEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

final class ExternalScriptable
implements Scriptable {
    private ScriptContext context = null;
    private Map indexedProps = null;
    private Scriptable prototype = null;
    private Scriptable parent = null;

    ExternalScriptable(ScriptContext context) {
        this(context, new HashMap());
    }

    ExternalScriptable(ScriptContext context, Map indexedProps) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        this.context = context;
        this.indexedProps = indexedProps;
    }

    ScriptContext getContext() {
        return this.context;
    }

    private boolean isInIndexedProps(Object key) {
        return this.indexedProps != null && this.indexedProps.containsKey(key);
    }

    private boolean isEmpty(String name) {
        return name.equals("");
    }

    public String getClassName() {
        return "Global";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(String name, Scriptable start) {
        Object value = null;
        if (this.isEmpty(name)) {
            if (this.indexedProps.containsKey(name)) {
                return this.indexedProps.get(name);
            }
            return NOT_FOUND;
        }
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            int scope = this.context.getAttributesScope(name);
            if (scope != -1) {
                value = this.context.getAttribute(name, scope);
            }
        }
        if (value != null) {
            return Context.javaToJS((Object)value, (Scriptable)this);
        }
        return NOT_FOUND;
    }

    public synchronized Object get(int index, Scriptable start) {
        Integer key = new Integer(index);
        if (this.indexedProps.containsKey(index)) {
            return this.indexedProps.get(key);
        }
        return NOT_FOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean has(String name, Scriptable start) {
        boolean ret = false;
        if (this.isEmpty(name)) {
            return this.indexedProps.containsKey(name);
        }
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            ret = this.context.getAttributesScope(name) != -1;
        }
        return ret;
    }

    public synchronized boolean has(int index, Scriptable start) {
        Integer key = new Integer(index);
        return this.indexedProps.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String name, Scriptable start, Object value) {
        if (start == this) {
            ExternalScriptable externalScriptable = this;
            synchronized (externalScriptable) {
                if (this.isEmpty(name)) {
                    this.indexedProps.put(name, value);
                } else {
                    int scope = -1;
                    ScriptContext scriptContext = this.context;
                    synchronized (scriptContext) {
                        scope = this.context.getAttributesScope(name);
                    }
                    if (scope == -1) {
                        scope = 100;
                    }
                    Object v = this.jsToJava(value);
                    ScriptContext scriptContext2 = this.context;
                    synchronized (scriptContext2) {
                        this.context.setAttribute(name, v, scope);
                    }
                }
            }
        }
        start.put(name, start, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int index, Scriptable start, Object value) {
        if (start == this) {
            ExternalScriptable externalScriptable = this;
            synchronized (externalScriptable) {
                this.indexedProps.put(new Integer(index), value);
            }
        } else {
            start.put(index, start, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(String name) {
        if (this.isEmpty(name)) {
            this.indexedProps.remove(name);
        } else {
            ScriptContext scriptContext = this.context;
            synchronized (scriptContext) {
                int scope = this.context.getAttributesScope(name);
                if (scope != -1) {
                    this.context.removeAttribute(name, scope);
                }
            }
        }
    }

    public void delete(int index) {
        this.indexedProps.remove(new Integer(index));
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public synchronized Object[] getIds() {
        String[] keys = this.getAllKeys();
        int size = keys.length + this.indexedProps.size();
        Object[] res = new Object[size];
        System.arraycopy(keys, 0, res, 0, keys.length);
        int i = keys.length;
        for (Object index : this.indexedProps.keySet()) {
            res[i++] = index;
        }
        return res;
    }

    public Object getDefaultValue(Class typeHint) {
        int i = 0;
        while (i < 2) {
            Object[] args;
            String methodName;
            boolean tryToString;
            if (typeHint == ScriptRuntime.StringClass) {
                tryToString = i == 0;
            } else {
                boolean bl = tryToString = i == 1;
            }
            if (tryToString) {
                methodName = "toString";
                args = ScriptRuntime.emptyArgs;
            } else {
                String hint;
                methodName = "valueOf";
                args = new Object[1];
                if (typeHint == null) {
                    hint = "undefined";
                } else if (typeHint == ScriptRuntime.StringClass) {
                    hint = "string";
                } else if (typeHint == ScriptRuntime.ScriptableClass) {
                    hint = "object";
                } else if (typeHint == ScriptRuntime.FunctionClass) {
                    hint = "function";
                } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                    hint = "boolean";
                } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                    hint = "number";
                } else {
                    throw Context.reportRuntimeError((String)("Invalid JavaScript value of type " + typeHint.toString()));
                }
                args[0] = hint;
            }
            Object v = ScriptableObject.getProperty((Scriptable)this, (String)methodName);
            if (v instanceof Function) {
                Function fun = (Function)v;
                Context cx = RhinoScriptEngine.enterContext();
                try {
                    v = fun.call(cx, fun.getParentScope(), (Scriptable)this, args);
                }
                finally {
                    Context.exit();
                }
                if (v != null) {
                    Object u;
                    if (!(v instanceof Scriptable)) {
                        return v;
                    }
                    if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                        return v;
                    }
                    if (tryToString && v instanceof Wrapper && (u = ((Wrapper)v).unwrap()) instanceof String) {
                        return u;
                    }
                }
            }
            ++i;
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw Context.reportRuntimeError((String)("Cannot find default value for object " + arg));
    }

    public boolean hasInstance(Scriptable instance) {
        Scriptable proto = instance.getPrototype();
        while (proto != null) {
            if (proto.equals(this)) {
                return true;
            }
            proto = proto.getPrototype();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAllKeys() {
        ArrayList<String> list = new ArrayList<String>();
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            for (int scope : this.context.getScopes()) {
                Bindings bindings = this.context.getBindings(scope);
                if (bindings == null) continue;
                list.ensureCapacity(bindings.size());
                for (String key : bindings.keySet()) {
                    list.add(key);
                }
            }
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    private Object jsToJava(Object jsObj) {
        if (jsObj instanceof Wrapper) {
            Wrapper njb = (Wrapper)jsObj;
            if (njb instanceof NativeJavaClass) {
                return njb;
            }
            Object obj = njb.unwrap();
            if (obj instanceof Number || obj instanceof String || obj instanceof Boolean || obj instanceof Character) {
                return njb;
            }
            return obj;
        }
        return jsObj;
    }
}

