/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveBuffer;
import org.maachang.comet.net.ssl.SslUtil;

public class SslElement {
    private NioElement element = null;
    private SSLEngine sslEngine = null;
    private int defaultSize = -1;
    private ByteBuffer netInBuffer = null;
    private ByteBuffer netOutBuffer = null;
    private ByteBuffer recvBuffer = null;
    private SSLEngineResult.HandshakeStatus handShakeState = null;
    private volatile boolean isHandShakeFinish = false;
    private volatile boolean isClose = false;
    private volatile boolean isExitHandShakeSend = false;

    private SslElement() {
    }

    public SslElement(NioElement element, SSLEngine sslEngine) throws Exception {
        if (sslEngine == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int recvBufferSize = sslEngine.getSession().getApplicationBufferSize();
        this.defaultSize = (int)((float)sslEngine.getSession().getPacketBufferSize() * 1.5f);
        this.recvBuffer = ByteBuffer.allocate(recvBufferSize);
        this.netInBuffer = ByteBuffer.allocate(this.defaultSize);
        this.netOutBuffer = ByteBuffer.allocate(this.defaultSize);
        this.netOutBuffer.limit(0);
        this.sslEngine = sslEngine;
        this.element = element;
        this.isHandShakeFinish = false;
        this.isExitHandShakeSend = false;
        this.isClose = false;
        this.sslEngine.beginHandshake();
        String[] supportCiphers = sslEngine.getSupportedCipherSuites();
        if (supportCiphers != null) {
            sslEngine.setEnabledCipherSuites(supportCiphers);
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.sslEngine != null) {
            try {
                this.sslEngine.closeOutbound();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.netInBuffer = null;
        this.netOutBuffer = null;
        this.sslEngine = null;
        this.element = null;
        this.recvBuffer = null;
        this.isClose = true;
    }

    public synchronized void close() throws Exception {
        if (this.element != null && this.element.isUse() && this.sslEngine != null) {
            this.element.restartWrite();
            this.sslEngine.closeOutbound();
            SSLEngineResult res = SslUtil.wrap(this.sslEngine, SslUtil.EMPTY_BUFFER, this.netOutBuffer);
            if (res.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.writeQueue(this.netOutBuffer);
            }
        }
    }

    public synchronized boolean isClosed() {
        return this.isClose;
    }

    public synchronized boolean isHandShake() {
        return this.isHandShakeFinish;
    }

    public synchronized void sendEndHandShake() {
        if (this.isHandShakeFinish) {
            this.isExitHandShakeSend = true;
            this.netInBuffer = ByteBuffer.allocate(this.defaultSize);
            this.netOutBuffer = ByteBuffer.allocate(this.defaultSize);
            this.netOutBuffer.limit(0);
        }
    }

    public synchronized boolean isSendEndHandShake() {
        return this.isExitHandShakeSend;
    }

    public synchronized ByteBuffer getRecvBuffer() {
        return this.recvBuffer;
    }

    public synchronized void handShake(ByteBuffer recvBuf) throws Exception {
        if (this.isClose) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.handShakeState == null) {
            this.sslEngine.beginHandshake();
            this.handShakeState = this.sslEngine.getHandshakeStatus();
        }
        SSLEngineResult result = null;
        if (this.isUseReadData(recvBuf)) {
            if (this.isHandShakeFinish) {
                throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u306f\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059");
            }
            result = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer);
            this.handShakeState = result.getHandshakeStatus();
            while (result.getStatus() != SSLEngineResult.Status.OK) {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.netInBuffer = SslUtil.reallocate(this.netInBuffer);
                    result = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer);
                    this.handShakeState = result.getHandshakeStatus();
                    continue;
                }
                throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)this.handShakeState) + "/" + (Object)((Object)result.getStatus()) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
            }
        } else {
            return;
        }
        boolean roopEnd = true;
        block7: while (roopEnd) {
            switch (this.handShakeState) {
                case NEED_WRAP: {
                    result = SslUtil.wrap(this.sslEngine, SslUtil.EMPTY_BUFFER, this.netOutBuffer);
                    this.handShakeState = result.getHandshakeStatus();
                    if (result.getStatus() == SSLEngineResult.Status.OK) {
                        this.writeQueue(this.netOutBuffer);
                        if (this.handShakeState != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) continue block7;
                        roopEnd = false;
                        break;
                    }
                    throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)this.handShakeState) + "/" + (Object)((Object)result.getStatus()) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                }
                case NEED_UNWRAP: {
                    if (this.isUseReadData(recvBuf)) {
                        while (true) {
                            result = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer);
                            this.handShakeState = result.getHandshakeStatus();
                            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue block7;
                            this.netInBuffer = SslUtil.reallocate(this.netInBuffer);
                        }
                    }
                    if (this.handShakeState != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.isUseReadData(recvBuf)) continue block7;
                    roopEnd = false;
                    break;
                }
                case NEED_TASK: {
                    this.handShakeState = this.tasks();
                    break;
                }
                case FINISHED: {
                    this.isHandShakeFinish = true;
                    roopEnd = false;
                    break;
                }
                default: {
                    throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)this.handShakeState) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                }
            }
        }
    }

    public synchronized boolean isUseReadData(ByteBuffer recvBuf) {
        boolean ret;
        boolean bl = ret = recvBuf.position() != 0 && recvBuf.hasRemaining() && this.handShakeState == SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        if (!ret) {
            return recvBuf.position() == recvBuf.capacity();
        }
        return ret;
    }

    public synchronized boolean read(ByteBuffer recvBuf) throws Exception {
        if (this.isClose) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isExitHandShakeSend) {
            throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u304c\u7d42\u4e86\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        ReceiveBuffer emtBuf = this.element.getBuffer();
        SocketChannel channel = this.element.getChannel();
        boolean flg = false;
        while (true) {
            int len;
            if ((len = channel.read(recvBuf)) <= 0) {
                if (len > -1) break;
                try {
                    this.sslEngine.closeInbound();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            this.readToSslConvert(emtBuf, recvBuf);
            flg = true;
        }
        if (flg) {
            this.element.update();
        }
        return flg;
    }

    public synchronized boolean readTo(ByteBuffer recvBuf) throws Exception {
        boolean ret = false;
        if (recvBuf.position() != 0 && recvBuf.hasRemaining()) {
            ReceiveBuffer emtBuf = this.element.getBuffer();
            while (recvBuf.position() != 0 && recvBuf.hasRemaining()) {
                int ln = this.readToSslConvert(emtBuf, recvBuf);
                ret = true;
                if (ln <= 0) break;
            }
        }
        return ret;
    }

    public synchronized void write(ByteBuffer buf) throws Exception {
        if (this.isClose) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isExitHandShakeSend) {
            throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u304c\u7d42\u4e86\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        int written = 0;
        SSLEngineResult result = SslUtil.wrap(this.sslEngine, buf, this.netOutBuffer);
        written = result.bytesConsumed();
        if (result.getStatus() == SSLEngineResult.Status.OK) {
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
        } else {
            throw new IOException("\u4e0d\u6b63\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)result.getStatus()) + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        }
        this.element.getChannel().write(this.netOutBuffer);
        if (buf.limit() != written) {
            buf.position(written);
            buf.compact();
            this.element.getWriteBuffer().appendHead(buf);
        }
    }

    private SSLEngineResult.HandshakeStatus tasks() {
        Runnable r = null;
        while ((r = this.sslEngine.getDelegatedTask()) != null) {
            r.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void writeQueue(ByteBuffer buf) {
        if (this.element != null && this.element.isUse()) {
            this.element.getWriteBuffer().append(SslUtil.copy(this.netOutBuffer));
        }
    }

    private int readToSslConvert(ReceiveBuffer emtBuf, ByteBuffer recvBuf) throws Exception {
        this.netInBuffer.clear();
        int recv = 0;
        do {
            SSLEngineResult unwrap;
            if ((unwrap = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer)).getStatus() == SSLEngineResult.Status.OK || unwrap.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                recv += unwrap.bytesProduced();
                if (unwrap.getStatus() == SSLEngineResult.Status.OK) {
                    this.netInBuffer.flip();
                    emtBuf.put(this.netInBuffer);
                    this.netInBuffer.clear();
                }
                if (unwrap.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (unwrap.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (unwrap.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && recv > 0 || unwrap.getStatus() == SSLEngineResult.Status.CLOSED || unwrap.getStatus() == SSLEngineResult.Status.CLOSED) break;
            throw new IOException("\u4e0d\u6b63\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)unwrap.getStatus()) + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        } while (recv != 0);
        return recv;
    }
}

