/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.util.LinkedList;

public class ReceiveBuffer {
    private LinkedList<byte[]> queue = new LinkedList();
    private int length = 0;

    protected ReceiveBuffer() {
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.queue != null) {
            this.queue.clear();
        }
        this.queue = null;
        this.length = 0;
    }

    public synchronized void reset() {
        if (this.queue != null) {
            this.queue.clear();
        }
        this.length = 0;
    }

    public synchronized void put(ByteBuffer buffer) throws Exception {
        if (buffer == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = buffer.limit();
        if (len <= 0) {
            return;
        }
        byte[] bin = new byte[len];
        buffer.get(bin, 0, len);
        this.queue.add(bin);
        this.length += len;
    }

    public synchronized byte[] get() {
        if (this.queue == null || this.queue.size() <= 0) {
            return null;
        }
        return this.queue.removeFirst();
    }

    public synchronized int length() {
        return this.length;
    }
}

