/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.net.HttpServer;
import org.maachang.comet.net.nio.HttpReceiveCallback;
import org.maachang.comet.net.nio.NioPoolThread;
import org.maachang.comet.net.nio.NioSslServer;
import org.maachang.comet.net.nio.NioTcpServer;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.comet.net.ssl.SslOption;
import org.maachang.conf.Config;
import org.maachang.manager.GlobalManager;
import org.maachang.util.SequenceSync;

public class NioService {
    private static final Log LOG = LogFactory.getLog(NioService.class);
    private static final int MIN_POOL = 5;
    private static final int MAX_POOL = 500;
    private static final int DEF_TCP_IO_LEN = 4;
    private static final int DEF_SSL_IO_LEN = 2;
    private NioTcpServer httpBase = null;
    private NioSslServer sslBase = null;
    private NioPoolThread[] pool = null;

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(HttpReceiveCallback call, HttpServer http, HttpServer ssl, int pool) throws Exception {
        if (call == null || http == null || http.isClosed()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (pool <= 5) {
            pool = 5;
        } else if (pool >= 500) {
            pool = 500;
        }
        this.close();
        Config conf = ((IniFile)GlobalManager.getInstance().get("CONFIG_MANAGER")).getConfig();
        int tcpRecvLen = conf.getInt("net", "io-thread", 0);
        if (tcpRecvLen <= 0) {
            tcpRecvLen = 4;
        }
        int sslRecvLen = 0;
        if (ssl != null && (sslRecvLen = conf.getInt("ssl", "io-thread", 0)) <= 0) {
            sslRecvLen = 2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("## tcpRecvLen:" + tcpRecvLen + " sslRecvLen:" + sslRecvLen));
        }
        try {
            ReceiveLinkQueue queue = new ReceiveLinkQueue();
            this.httpBase = new NioTcpServer(tcpRecvLen, http.channel(), queue);
            if (ssl != null) {
                this.sslBase = new NioSslServer(sslRecvLen, ssl.channel(), (SslOption)ssl.option(), queue);
            }
            SequenceSync seq = new SequenceSync();
            this.pool = new NioPoolThread[pool];
            int i = 0;
            while (i < pool) {
                this.pool[i] = new NioPoolThread(call, queue, seq);
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## error", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void close() {
        if (this.pool != null) {
            int len = this.pool.length;
            int i = 0;
            while (i < len) {
                if (this.pool[i] != null) {
                    this.pool[i].destroy();
                }
                this.pool[i] = null;
                ++i;
            }
        }
        if (this.httpBase != null) {
            this.httpBase.destroy();
        }
        if (this.sslBase != null) {
            this.sslBase.destroy();
        }
        this.pool = null;
        this.httpBase = null;
        this.sslBase = null;
    }
}

