/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveBuffer;

class NioInputStream
extends InputStream {
    private static final long TIMEOUT = 5000L;
    private static final long MIN_TIMEOUT = 500L;
    private NioElement element = null;
    private byte[] buffer = null;
    private int bufferToPos = 0;
    private int count = 0;
    private long timeout = -1L;

    private NioInputStream() {
    }

    public NioInputStream(NioElement element) {
        this(element, 5000L);
    }

    public NioInputStream(NioElement element, long timeout) {
        this.element = element;
        this.count = 0;
        this.timeout = timeout <= 500L ? 500L : timeout;
        this.buffer = null;
        this.bufferToPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        NioInputStream nioInputStream = this;
        synchronized (nioInputStream) {
            if (this.element != null && this.element.getBuffer() != null) {
                this.element.getBuffer().reset();
            }
            this.element = null;
            this.count = 0;
            this.buffer = null;
            this.bufferToPos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        int ret;
        if (this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        NioInputStream nioInputStream = this;
        synchronized (nioInputStream) {
            ret = this.element.getBuffer().length() - this.count;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        ReceiveBuffer bm;
        if (this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        byte[] b = null;
        int bPos = 0;
        NioInputStream nioInputStream = this;
        synchronized (nioInputStream) {
            bm = this.element.getBuffer();
            b = this.buffer;
            bPos = this.bufferToPos;
        }
        if (b == null) {
            while (true) {
                long time = System.currentTimeMillis();
                b = bm.get();
                if (b != null) {
                    NioInputStream nioInputStream2 = this;
                    synchronized (nioInputStream2) {
                        this.buffer = b;
                        this.bufferToPos = 0;
                        bPos = 0;
                        break;
                    }
                }
                if (time + this.timeout <= System.currentTimeMillis()) {
                    throw new SocketTimeoutException("SocketTimeout");
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {}
            }
        }
        int ret = b[bPos] & 0xFF;
        if (bPos + 1 >= b.length) {
            NioInputStream nioInputStream3 = this;
            synchronized (nioInputStream3) {
                this.buffer = null;
                this.bufferToPos = 0;
                ++this.count;
            }
        }
        NioInputStream nioInputStream4 = this;
        synchronized (nioInputStream4) {
            ++this.bufferToPos;
            ++this.count;
        }
        return ret;
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUse() {
        boolean ret;
        NioInputStream nioInputStream = this;
        synchronized (nioInputStream) {
            ret = this.element == null || !this.element.isUse();
        }
        return ret;
    }
}

