/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.scripts.PageCache;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class ReadScriptPlus {
    private static final String[] CACHE_BY_EXIT = new String[]{"catch", "{", "_isExitTo();"};
    private static final String DIRECT_INCLUDE = "@include";

    private ReadScriptPlus() {
    }

    public static final String convert(boolean comment, String script) throws Exception {
        if (script == null || (script = script.trim()).length() <= 0) {
            return "";
        }
        if (comment) {
            script = ReadScriptPlus.cutComment(script);
        }
        script = ReadScriptPlus.add(script, CACHE_BY_EXIT[0], CACHE_BY_EXIT[1], CACHE_BY_EXIT[2]);
        return script;
    }

    protected static final String cutComment(String script) throws Exception {
        if (script == null || (script = script.trim()).length() <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = script.length();
        int n = -1;
        int commentType = -1;
        int bef = -1;
        int i = 0;
        while (i < len) {
            block14: {
                char c;
                block19: {
                    char c2;
                    block16: {
                        char c22;
                        block18: {
                            block17: {
                                block15: {
                                    block13: {
                                        if (i != 0) {
                                            bef = script.charAt(i - 1);
                                        }
                                        c = script.charAt(i);
                                        if (c2 == -1) break block13;
                                        if (c == c2 && (char)bef != '\\') {
                                            c2 = '\uffffffff';
                                        }
                                        buf.append(c);
                                        break block14;
                                    }
                                    if (commentType == -1) break block15;
                                    if (commentType == 1) {
                                        if (c == '\n' || c == '\r') {
                                            if (c == '\r') {
                                                if (len > i + 1 && script.charAt(i + 1) == '\n') {
                                                    ++i;
                                                    buf.append("\r\n");
                                                } else {
                                                    buf.append(c);
                                                }
                                            } else {
                                                buf.append(c);
                                            }
                                            commentType = -1;
                                        }
                                    } else if (commentType == 2 && c == '*' && len > i + 1 && script.charAt(i + 1) == '/') {
                                        ++i;
                                        commentType = -1;
                                    }
                                    break block14;
                                }
                                if (c != '/') break block16;
                                if (len > i + 1) break block17;
                                buf.append(c);
                                break block14;
                            }
                            c22 = script.charAt(i + 1);
                            if (c22 != '*') break block18;
                            commentType = 2;
                            break block14;
                        }
                        if (c22 != '/') break block19;
                        commentType = 1;
                        break block14;
                    }
                    if (c == '\'' || c == '\"') {
                        c2 = c & 0xFFFF;
                    }
                }
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private static final String add(String script, String main, String sub, String inc) throws Exception {
        if (script == null || (script = script.trim()).length() <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = script.length();
        int n = -1;
        int startPos = -1;
        boolean target = false;
        char[] mainChars = main.toCharArray();
        char[] subChars = null;
        if (sub != null && sub.length() > 0) {
            subChars = sub.toCharArray();
        }
        int bef = -1;
        int i = 0;
        while (i < len) {
            block14: {
                char c;
                char c2;
                block15: {
                    block19: {
                        block20: {
                            block18: {
                                block17: {
                                    block16: {
                                        block13: {
                                            if (i != 0) {
                                                bef = script.charAt(i - 1);
                                            }
                                            c2 = script.charAt(i);
                                            if (c == -1) break block13;
                                            if (c2 == c && (char)bef != '\\') {
                                                c = '\uffffffff';
                                            }
                                            buf.append(c2);
                                            startPos = -1;
                                            break block14;
                                        }
                                        if (!target) break block15;
                                        if (subChars != null) break block16;
                                        buf.append(inc);
                                        buf.append(c2);
                                        startPos = -1;
                                        target = false;
                                        break block14;
                                    }
                                    if (c2 != '\'' && c2 != '\"') break block17;
                                    c = c2 & 0xFFFF;
                                    buf.append(c2);
                                    startPos = -1;
                                    break block14;
                                }
                                if (startPos != -1) break block18;
                                if (subChars[0] != c2 || (startPos = 1) < subChars.length) break block19;
                                buf.append(c2);
                                buf.append(inc);
                                startPos = -1;
                                target = false;
                                break block14;
                            }
                            if (subChars[startPos] != c2) break block20;
                            if (++startPos < subChars.length) break block19;
                            buf.append(c2);
                            buf.append(inc);
                            startPos = -1;
                            target = false;
                            break block14;
                        }
                        startPos = -1;
                    }
                    buf.append(c2);
                    break block14;
                }
                if (c2 == '\'' || c2 == '\"') {
                    c = c2 & 0xFFFF;
                    buf.append(c2);
                    startPos = -1;
                } else {
                    if (startPos == -1) {
                        if (mainChars[0] == c2 && (startPos = 1) >= mainChars.length) {
                            startPos = -1;
                            target = true;
                        }
                    } else if (mainChars[startPos] == c2) {
                        if (++startPos >= mainChars.length) {
                            startPos = -1;
                            target = true;
                        }
                    } else {
                        startPos = -1;
                    }
                    buf.append(c2);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static final void addMHTML(StringBuilder buf, String script, String path) throws Exception {
        buf.append("_$script$lastMHTML").append("=\"").append(path).append("\";\n");
        buf.append("setContentType(\"").append("text/html; charset=utf-8").append("\");").append("\n");
        buf.append("var scriptMemorys = Bindings() ;\nvar params = jmap(_$script$query);\nvar sessions = sessionMap();\n");
        buf.append(script);
        buf.append("_exit(").append("\"exit-script\"").append(") ;").append("\n");
    }

    public static final String directInclude(String currentDir, String script) throws Exception {
        if (currentDir == null || (currentDir = currentDir.trim()).length() <= 0 || script == null || script.length() <= 0) {
            return script;
        }
        int b = 0;
        int p = StringUtil.indexToNotCote((String)script, (String)DIRECT_INCLUDE, (int)b);
        if (p <= -1) {
            return script;
        }
        int incLen = DIRECT_INCLUDE.length();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            if (i != 0 && (p = StringUtil.indexToNotCote((String)script, (String)DIRECT_INCLUDE, (int)b)) <= -1) {
                buf.append(script.substring(b));
                break;
            }
            int cst = StringUtil.indexToNotCote((String)script, (String)"(", (int)p);
            if (cst <= -1) {
                buf.append(script.substring(b, p));
                b = p + incLen;
            } else {
                int ced = StringUtil.indexParAndCote((String)script, (char)'(', (char)')', (int)p);
                if (ced <= -1) {
                    buf.append(script.substring(b, p));
                    b = p + incLen;
                } else {
                    String name;
                    int ed = StringUtil.indexToNotCote((String)script, (String)";", (int)ced);
                    int eed = StringUtil.indexToNotCote((String)script, (String)"\n", (int)ced);
                    if (ed <= -1 || ed > eed) {
                        ed = eed;
                    }
                    if (ed <= -1) {
                        ed = script.length();
                    }
                    if ((name = StringUtil.trim((String)script.substring(cst + 1, ced))) == null || name.length() <= 0) {
                        buf.append(script.substring(b, p));
                        b = ed + 1;
                    } else if (!StringUtil.isCote((String)name)) {
                        buf.append(script.substring(b, p));
                        b = ed + 1;
                    } else {
                        String inner = ReadScriptPlus.getInnerFile(currentDir, name = StringUtil.cutCote((String)name));
                        if (inner == null) {
                            buf.append(script.substring(b, p));
                            b = ed + 1;
                        } else {
                            buf.append(script.substring(b, p));
                            buf.append(inner);
                            b = ed + 1;
                            if (b >= script.length()) break;
                        }
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String getInnerFile(String currentDirectory, String path) throws Exception {
        String fileName;
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + "application/" + (path.startsWith("/") ? path.substring(1, path.length()) : path)))) {
            return null;
        }
        String script = FileUtil.getFileByString((String)fileName, (String)"UTF8");
        if (script == null) {
            return null;
        }
        String[] sc = new String[]{script};
        long tm = PageCache.getInstance().analysisCacheMode(sc);
        if (tm > 0L) {
            script = sc[0];
        }
        sc = null;
        return script;
    }
}

