/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.PageCache;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScriptAnalysis;
import org.maachang.comet.httpd.engine.script.taglib.AnalysisTagLib;
import org.maachang.util.FileUtil;

public class InnerScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected long updateTime = -1L;
    protected ExecutionScriptImpl executionScript = null;
    private SrcScript srcScript = null;
    private int packageId = -1;

    private InnerScript() {
    }

    public InnerScript(String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + "application/" + (path.startsWith("/") ? path.substring(1, path.length()) : path)))) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30a4\u30f3\u30ca\u30fc\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path;
        this.fileName = fileName;
    }

    protected void clear() {
        this.updateTime = -1L;
        this.srcScript = null;
        this.executionScript = null;
    }

    public synchronized ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            this.clear();
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30a4\u30f3\u30ca\u30fc\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript == null || this.updateTime != FileUtil.getLastTime((String)this.fileName) || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getScriptName() {
        return this.fileName;
    }

    public int getScriptType() {
        return 32;
    }

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    protected void readScript() throws Exception {
        StringBuilder buf;
        String script = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
        if (script == null) {
            this.executionScript = null;
            return;
        }
        String[] sc = new String[]{script};
        long tm = PageCache.getInstance().analysisCacheMode(sc);
        if (tm > 0L) {
            script = sc[0];
            sc = null;
            script = AnalysisTagLib.analysis(script);
            script = TemplateScriptAnalysis.analysis("_$cache$inner.ad", script);
            buf = new StringBuilder();
            buf.append("var _$cache$inner = new StrBuf() ;\n");
            buf.append(script);
            buf.append("var _$cache$inner$out = _$cache$inner.ts() ;\n_$cache$inner.clear();\n_$cache$inner=null;\n").append("org.maachang.comet.httpd.engine.script.scripts.PageCache.getInstance().set( \"").append("@inner@").append(this.path).append("\",").append(tm).append(",_$cache$inner$out ) ;\n").append("httpPrint( _$cache$inner$out ) ;\n");
            script = buf.toString();
            buf = null;
        } else {
            sc = null;
            script = AnalysisTagLib.analysis(script);
            script = TemplateScriptAnalysis.analysis(script);
        }
        buf = new StringBuilder();
        this.packageId = JsDef.pushDefaultPackage(buf);
        buf.append("var scriptMemorys = Bindings() ;\nvar params = jmap(_$script$query);\nvar sessions = sessionMap();\n");
        buf.append(script);
        script = buf.toString();
        buf = null;
        script = ReadScriptPlus.convert(true, script);
        this.srcScript = new SrcScript(script);
        this.executionScript = new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script);
        script = null;
        this.updateTime = FileUtil.getLastTime((String)this.fileName);
    }
}

