/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.util.FileUtil;

public class EtcScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected long updateTime = -1L;
    private SrcScript srcScript = null;
    protected ExecutionScript executionScript = null;
    private int packageId = -1;

    public EtcScript(String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + path))) {
            throw new HttpdStateException(500, "\u6307\u5b9a\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path.substring(0, path.length() - ".ms".length());
        this.fileName = fileName;
    }

    protected void clear() {
        this.updateTime = -1L;
        this.srcScript = null;
        this.executionScript = null;
    }

    public synchronized ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            this.clear();
        } else if (this.executionScript == null || this.updateTime != FileUtil.getLastTime((String)this.fileName) || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getScriptName() {
        return this.fileName;
    }

    public int getScriptType() {
        return 99;
    }

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    protected void readScript() throws Exception {
        StringBuilder buf = new StringBuilder();
        this.packageId = JsDef.pushDefaultPackage(buf);
        buf.append(FileUtil.getFileByString((String)this.fileName, (String)"UTF8"));
        String script = buf.toString();
        buf = null;
        script = ReadScriptPlus.convert(true, script);
        this.srcScript = new SrcScript(script);
        this.executionScript = new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script);
        script = null;
        this.updateTime = FileUtil.getLastTime((String)this.fileName);
    }
}

